<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicPropertyInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBasicPropertyInfoType extends AbstractStructBase
{
    /**
     * The HotelID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $HotelID;
    /**
     * The Guarentee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guarentee;
    /**
     * The Stay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Stay;
    /**
     * The Deposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deposit;
    /**
     * The Safety
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Safety;
    /**
     * The FireSafety
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FireSafety;
    /**
     * The Transportation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transportation;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax;
    /**
     * The Meals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Meals;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString
     */
    public $Images;
    /**
     * The ExtraCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraCharges;
    /**
     * The BestTransportationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BestTransportationType;
    /**
     * The AddRoomOccupant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddRoomOccupant;
    /**
     * The ThumbnailImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThumbnailImage;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPosition
     */
    public $Position;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber
     */
    public $ContactNumbers;
    /**
     * The Award
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAward[]
     */
    public $Award;
    /**
     * The Introduction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Introduction;
    /**
     * The RelativePosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRelativePositionType
     */
    public $RelativePosition;
    /**
     * The HotelAmenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelAmenity[]
     */
    public $HotelAmenity;
    /**
     * The Recreation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRecreation[]
     */
    public $Recreation;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgService[]
     */
    public $Service;
    /**
     * The Policy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Policy;
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * @var string
     */
    public $BrandName;
    /**
     * The HotelSegmentCategoryCode
     * @var string
     */
    public $HotelSegmentCategoryCode;
    /**
     * The SupplierIntegrationLevel
     * @var int
     */
    public $SupplierIntegrationLevel;
    /**
     * Constructor method for BasicPropertyInfoType
     * @uses DgBasicPropertyInfoType::setHotelID()
     * @uses DgBasicPropertyInfoType::setGuarentee()
     * @uses DgBasicPropertyInfoType::setStay()
     * @uses DgBasicPropertyInfoType::setDeposit()
     * @uses DgBasicPropertyInfoType::setSafety()
     * @uses DgBasicPropertyInfoType::setFireSafety()
     * @uses DgBasicPropertyInfoType::setTransportation()
     * @uses DgBasicPropertyInfoType::setTax()
     * @uses DgBasicPropertyInfoType::setMeals()
     * @uses DgBasicPropertyInfoType::setImages()
     * @uses DgBasicPropertyInfoType::setExtraCharges()
     * @uses DgBasicPropertyInfoType::setBestTransportationType()
     * @uses DgBasicPropertyInfoType::setAddRoomOccupant()
     * @uses DgBasicPropertyInfoType::setThumbnailImage()
     * @uses DgBasicPropertyInfoType::setPosition()
     * @uses DgBasicPropertyInfoType::setAddress()
     * @uses DgBasicPropertyInfoType::setContactNumbers()
     * @uses DgBasicPropertyInfoType::setAward()
     * @uses DgBasicPropertyInfoType::setIntroduction()
     * @uses DgBasicPropertyInfoType::setRelativePosition()
     * @uses DgBasicPropertyInfoType::setHotelAmenity()
     * @uses DgBasicPropertyInfoType::setRecreation()
     * @uses DgBasicPropertyInfoType::setService()
     * @uses DgBasicPropertyInfoType::setPolicy()
     * @uses DgBasicPropertyInfoType::setChainCode()
     * @uses DgBasicPropertyInfoType::setBrandCode()
     * @uses DgBasicPropertyInfoType::setHotelCode()
     * @uses DgBasicPropertyInfoType::setHotelCityCode()
     * @uses DgBasicPropertyInfoType::setHotelName()
     * @uses DgBasicPropertyInfoType::setHotelCodeContext()
     * @uses DgBasicPropertyInfoType::setChainName()
     * @uses DgBasicPropertyInfoType::setBrandName()
     * @uses DgBasicPropertyInfoType::setHotelSegmentCategoryCode()
     * @uses DgBasicPropertyInfoType::setSupplierIntegrationLevel()
     * @param int $hotelID
     * @param string $guarentee
     * @param string $stay
     * @param string $deposit
     * @param string $safety
     * @param string $fireSafety
     * @param string $transportation
     * @param string $tax
     * @param string $meals
     * @param \dgsoft\ArrayType\DgArrayOfString $images
     * @param string $extraCharges
     * @param string $bestTransportationType
     * @param string $addRoomOccupant
     * @param string $thumbnailImage
     * @param \dgsoft\StructType\DgPosition $position
     * @param \dgsoft\StructType\DgAddressInfoType $address
     * @param \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber $contactNumbers
     * @param \dgsoft\StructType\DgAward[] $award
     * @param string $introduction
     * @param \dgsoft\StructType\DgRelativePositionType $relativePosition
     * @param \dgsoft\StructType\DgHotelAmenity[] $hotelAmenity
     * @param \dgsoft\StructType\DgRecreation[] $recreation
     * @param \dgsoft\StructType\DgService[] $service
     * @param string $policy
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $hotelSegmentCategoryCode
     * @param int $supplierIntegrationLevel
     */
    public function __construct($hotelID = null, $guarentee = null, $stay = null, $deposit = null, $safety = null, $fireSafety = null, $transportation = null, $tax = null, $meals = null, \dgsoft\ArrayType\DgArrayOfString $images = null, $extraCharges = null, $bestTransportationType = null, $addRoomOccupant = null, $thumbnailImage = null, \dgsoft\StructType\DgPosition $position = null, \dgsoft\StructType\DgAddressInfoType $address = null, \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber $contactNumbers = null, array $award = array(), $introduction = null, \dgsoft\StructType\DgRelativePositionType $relativePosition = null, array $hotelAmenity = array(), array $recreation = array(), array $service = array(), $policy = null, $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $hotelSegmentCategoryCode = null, $supplierIntegrationLevel = null)
    {
        $this
            ->setHotelID($hotelID)
            ->setGuarentee($guarentee)
            ->setStay($stay)
            ->setDeposit($deposit)
            ->setSafety($safety)
            ->setFireSafety($fireSafety)
            ->setTransportation($transportation)
            ->setTax($tax)
            ->setMeals($meals)
            ->setImages($images)
            ->setExtraCharges($extraCharges)
            ->setBestTransportationType($bestTransportationType)
            ->setAddRoomOccupant($addRoomOccupant)
            ->setThumbnailImage($thumbnailImage)
            ->setPosition($position)
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setAward($award)
            ->setIntroduction($introduction)
            ->setRelativePosition($relativePosition)
            ->setHotelAmenity($hotelAmenity)
            ->setRecreation($recreation)
            ->setService($service)
            ->setPolicy($policy)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setHotelSegmentCategoryCode($hotelSegmentCategoryCode)
            ->setSupplierIntegrationLevel($supplierIntegrationLevel);
    }
    /**
     * Get HotelID value
     * @return int
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param int $hotelID
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelID) && !is_numeric($hotelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Get Guarentee value
     * @return string|null
     */
    public function getGuarentee()
    {
        return $this->Guarentee;
    }
    /**
     * Set Guarentee value
     * @param string $guarentee
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setGuarentee($guarentee = null)
    {
        // validation for constraint: string
        if (!is_null($guarentee) && !is_string($guarentee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guarentee)), __LINE__);
        }
        $this->Guarentee = $guarentee;
        return $this;
    }
    /**
     * Get Stay value
     * @return string|null
     */
    public function getStay()
    {
        return $this->Stay;
    }
    /**
     * Set Stay value
     * @param string $stay
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setStay($stay = null)
    {
        // validation for constraint: string
        if (!is_null($stay) && !is_string($stay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stay)), __LINE__);
        }
        $this->Stay = $stay;
        return $this;
    }
    /**
     * Get Deposit value
     * @return string|null
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * Set Deposit value
     * @param string $deposit
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: string
        if (!is_null($deposit) && !is_string($deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deposit)), __LINE__);
        }
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Get Safety value
     * @return string|null
     */
    public function getSafety()
    {
        return $this->Safety;
    }
    /**
     * Set Safety value
     * @param string $safety
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setSafety($safety = null)
    {
        // validation for constraint: string
        if (!is_null($safety) && !is_string($safety)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($safety)), __LINE__);
        }
        $this->Safety = $safety;
        return $this;
    }
    /**
     * Get FireSafety value
     * @return string|null
     */
    public function getFireSafety()
    {
        return $this->FireSafety;
    }
    /**
     * Set FireSafety value
     * @param string $fireSafety
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setFireSafety($fireSafety = null)
    {
        // validation for constraint: string
        if (!is_null($fireSafety) && !is_string($fireSafety)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fireSafety)), __LINE__);
        }
        $this->FireSafety = $fireSafety;
        return $this;
    }
    /**
     * Get Transportation value
     * @return string|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * Set Transportation value
     * @param string $transportation
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setTransportation($transportation = null)
    {
        // validation for constraint: string
        if (!is_null($transportation) && !is_string($transportation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transportation)), __LINE__);
        }
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Get Tax value
     * @return string|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param string $tax
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setTax($tax = null)
    {
        // validation for constraint: string
        if (!is_null($tax) && !is_string($tax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Meals value
     * @return string|null
     */
    public function getMeals()
    {
        return $this->Meals;
    }
    /**
     * Set Meals value
     * @param string $meals
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setMeals($meals = null)
    {
        // validation for constraint: string
        if (!is_null($meals) && !is_string($meals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meals)), __LINE__);
        }
        $this->Meals = $meals;
        return $this;
    }
    /**
     * Get Images value
     * @return \dgsoft\ArrayType\DgArrayOfString|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \dgsoft\ArrayType\DgArrayOfString $images
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setImages(\dgsoft\ArrayType\DgArrayOfString $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ExtraCharges value
     * @return string|null
     */
    public function getExtraCharges()
    {
        return $this->ExtraCharges;
    }
    /**
     * Set ExtraCharges value
     * @param string $extraCharges
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setExtraCharges($extraCharges = null)
    {
        // validation for constraint: string
        if (!is_null($extraCharges) && !is_string($extraCharges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extraCharges)), __LINE__);
        }
        $this->ExtraCharges = $extraCharges;
        return $this;
    }
    /**
     * Get BestTransportationType value
     * @return string|null
     */
    public function getBestTransportationType()
    {
        return $this->BestTransportationType;
    }
    /**
     * Set BestTransportationType value
     * @param string $bestTransportationType
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setBestTransportationType($bestTransportationType = null)
    {
        // validation for constraint: string
        if (!is_null($bestTransportationType) && !is_string($bestTransportationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bestTransportationType)), __LINE__);
        }
        $this->BestTransportationType = $bestTransportationType;
        return $this;
    }
    /**
     * Get AddRoomOccupant value
     * @return string|null
     */
    public function getAddRoomOccupant()
    {
        return $this->AddRoomOccupant;
    }
    /**
     * Set AddRoomOccupant value
     * @param string $addRoomOccupant
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setAddRoomOccupant($addRoomOccupant = null)
    {
        // validation for constraint: string
        if (!is_null($addRoomOccupant) && !is_string($addRoomOccupant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addRoomOccupant)), __LINE__);
        }
        $this->AddRoomOccupant = $addRoomOccupant;
        return $this;
    }
    /**
     * Get ThumbnailImage value
     * @return string|null
     */
    public function getThumbnailImage()
    {
        return $this->ThumbnailImage;
    }
    /**
     * Set ThumbnailImage value
     * @param string $thumbnailImage
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setThumbnailImage($thumbnailImage = null)
    {
        // validation for constraint: string
        if (!is_null($thumbnailImage) && !is_string($thumbnailImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thumbnailImage)), __LINE__);
        }
        $this->ThumbnailImage = $thumbnailImage;
        return $this;
    }
    /**
     * Get Position value
     * @return \dgsoft\StructType\DgPosition|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \dgsoft\StructType\DgPosition $position
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setPosition(\dgsoft\StructType\DgPosition $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \dgsoft\StructType\DgAddressInfoType $address
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setAddress(\dgsoft\StructType\DgAddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber $contactNumbers
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setContactNumbers(\dgsoft\ArrayType\DgArrayOfBasicPropertyInfoTypeContactNumber $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Award value
     * @return \dgsoft\StructType\DgAward[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAward[] $award
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setAward(array $award = array())
    {
        foreach ($award as $basicPropertyInfoTypeAwardItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeAwardItem instanceof \dgsoft\StructType\DgAward) {
                throw new \InvalidArgumentException(sprintf('The Award property can only contain items of \dgsoft\StructType\DgAward, "%s" given', is_object($basicPropertyInfoTypeAwardItem) ? get_class($basicPropertyInfoTypeAwardItem) : gettype($basicPropertyInfoTypeAwardItem)), __LINE__);
            }
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAward $item
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function addToAward(\dgsoft\StructType\DgAward $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAward) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of \dgsoft\StructType\DgAward, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get Introduction value
     * @return string|null
     */
    public function getIntroduction()
    {
        return $this->Introduction;
    }
    /**
     * Set Introduction value
     * @param string $introduction
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setIntroduction($introduction = null)
    {
        // validation for constraint: string
        if (!is_null($introduction) && !is_string($introduction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($introduction)), __LINE__);
        }
        $this->Introduction = $introduction;
        return $this;
    }
    /**
     * Get RelativePosition value
     * @return \dgsoft\StructType\DgRelativePositionType|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * Set RelativePosition value
     * @param \dgsoft\StructType\DgRelativePositionType $relativePosition
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setRelativePosition(\dgsoft\StructType\DgRelativePositionType $relativePosition = null)
    {
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Get HotelAmenity value
     * @return \dgsoft\StructType\DgHotelAmenity[]|null
     */
    public function getHotelAmenity()
    {
        return $this->HotelAmenity;
    }
    /**
     * Set HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelAmenity[] $hotelAmenity
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelAmenity(array $hotelAmenity = array())
    {
        foreach ($hotelAmenity as $basicPropertyInfoTypeHotelAmenityItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeHotelAmenityItem instanceof \dgsoft\StructType\DgHotelAmenity) {
                throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of \dgsoft\StructType\DgHotelAmenity, "%s" given', is_object($basicPropertyInfoTypeHotelAmenityItem) ? get_class($basicPropertyInfoTypeHotelAmenityItem) : gettype($basicPropertyInfoTypeHotelAmenityItem)), __LINE__);
            }
        }
        $this->HotelAmenity = $hotelAmenity;
        return $this;
    }
    /**
     * Add item to HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelAmenity $item
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function addToHotelAmenity(\dgsoft\StructType\DgHotelAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgHotelAmenity) {
            throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of \dgsoft\StructType\DgHotelAmenity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelAmenity[] = $item;
        return $this;
    }
    /**
     * Get Recreation value
     * @return \dgsoft\StructType\DgRecreation[]|null
     */
    public function getRecreation()
    {
        return $this->Recreation;
    }
    /**
     * Set Recreation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRecreation[] $recreation
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setRecreation(array $recreation = array())
    {
        foreach ($recreation as $basicPropertyInfoTypeRecreationItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeRecreationItem instanceof \dgsoft\StructType\DgRecreation) {
                throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of \dgsoft\StructType\DgRecreation, "%s" given', is_object($basicPropertyInfoTypeRecreationItem) ? get_class($basicPropertyInfoTypeRecreationItem) : gettype($basicPropertyInfoTypeRecreationItem)), __LINE__);
            }
        }
        $this->Recreation = $recreation;
        return $this;
    }
    /**
     * Add item to Recreation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRecreation $item
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function addToRecreation(\dgsoft\StructType\DgRecreation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRecreation) {
            throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of \dgsoft\StructType\DgRecreation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Recreation[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \dgsoft\StructType\DgService[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgService[] $service
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setService(array $service = array())
    {
        foreach ($service as $basicPropertyInfoTypeServiceItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeServiceItem instanceof \dgsoft\StructType\DgService) {
                throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \dgsoft\StructType\DgService, "%s" given', is_object($basicPropertyInfoTypeServiceItem) ? get_class($basicPropertyInfoTypeServiceItem) : gettype($basicPropertyInfoTypeServiceItem)), __LINE__);
            }
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgService $item
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function addToService(\dgsoft\StructType\DgService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgService) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \dgsoft\StructType\DgService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return string|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * Set Policy value
     * @param string $policy
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setPolicy($policy = null)
    {
        // validation for constraint: string
        if (!is_null($policy) && !is_string($policy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policy)), __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get HotelSegmentCategoryCode value
     * @return string|null
     */
    public function getHotelSegmentCategoryCode()
    {
        return $this->HotelSegmentCategoryCode;
    }
    /**
     * Set HotelSegmentCategoryCode value
     * @param string $hotelSegmentCategoryCode
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setHotelSegmentCategoryCode($hotelSegmentCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelSegmentCategoryCode) && !is_string($hotelSegmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelSegmentCategoryCode)), __LINE__);
        }
        $this->HotelSegmentCategoryCode = $hotelSegmentCategoryCode;
        return $this;
    }
    /**
     * Get SupplierIntegrationLevel value
     * @return int|null
     */
    public function getSupplierIntegrationLevel()
    {
        return $this->SupplierIntegrationLevel;
    }
    /**
     * Set SupplierIntegrationLevel value
     * @param int $supplierIntegrationLevel
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public function setSupplierIntegrationLevel($supplierIntegrationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($supplierIntegrationLevel) && !is_numeric($supplierIntegrationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierIntegrationLevel)), __LINE__);
        }
        $this->SupplierIntegrationLevel = $supplierIntegrationLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBasicPropertyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
