<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseEntity StructType
 * @package Dg
 * @subpackage Structs
 */
abstract class DgBaseEntity extends AbstractStructBase
{
    /**
     * The ValidationErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfValidationError
     */
    public $ValidationErrors;
    /**
     * The SelfValidationErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfValidationError
     */
    public $SelfValidationErrors;
    /**
     * Constructor method for BaseEntity
     * @uses DgBaseEntity::setValidationErrors()
     * @uses DgBaseEntity::setSelfValidationErrors()
     * @param \dgsoft\ArrayType\DgArrayOfValidationError $validationErrors
     * @param \dgsoft\ArrayType\DgArrayOfValidationError $selfValidationErrors
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfValidationError $validationErrors = null, \dgsoft\ArrayType\DgArrayOfValidationError $selfValidationErrors = null)
    {
        $this
            ->setValidationErrors($validationErrors)
            ->setSelfValidationErrors($selfValidationErrors);
    }
    /**
     * Get ValidationErrors value
     * @return \dgsoft\ArrayType\DgArrayOfValidationError|null
     */
    public function getValidationErrors()
    {
        return $this->ValidationErrors;
    }
    /**
     * Set ValidationErrors value
     * @param \dgsoft\ArrayType\DgArrayOfValidationError $validationErrors
     * @return \dgsoft\StructType\DgBaseEntity
     */
    public function setValidationErrors(\dgsoft\ArrayType\DgArrayOfValidationError $validationErrors = null)
    {
        $this->ValidationErrors = $validationErrors;
        return $this;
    }
    /**
     * Get SelfValidationErrors value
     * @return \dgsoft\ArrayType\DgArrayOfValidationError|null
     */
    public function getSelfValidationErrors()
    {
        return $this->SelfValidationErrors;
    }
    /**
     * Set SelfValidationErrors value
     * @param \dgsoft\ArrayType\DgArrayOfValidationError $selfValidationErrors
     * @return \dgsoft\StructType\DgBaseEntity
     */
    public function setSelfValidationErrors(\dgsoft\ArrayType\DgArrayOfValidationError $selfValidationErrors = null)
    {
        $this->SelfValidationErrors = $selfValidationErrors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBaseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
