<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAcctType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBankAcctType extends AbstractStructBase
{
    /**
     * The BankAcctName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAcctName;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The BankID
     * @var string
     */
    public $BankID;
    /**
     * The AcctType
     * @var string
     */
    public $AcctType;
    /**
     * The BankAcctNumber
     * @var string
     */
    public $BankAcctNumber;
    /**
     * The ChecksAcceptedInd
     * @var bool
     */
    public $ChecksAcceptedInd;
    /**
     * Constructor method for BankAcctType
     * @uses DgBankAcctType::setBankAcctName()
     * @uses DgBankAcctType::setShareSynchInd()
     * @uses DgBankAcctType::setShareMarketInd()
     * @uses DgBankAcctType::setBankID()
     * @uses DgBankAcctType::setAcctType()
     * @uses DgBankAcctType::setBankAcctNumber()
     * @uses DgBankAcctType::setChecksAcceptedInd()
     * @param string $bankAcctName
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $bankID
     * @param string $acctType
     * @param string $bankAcctNumber
     * @param bool $checksAcceptedInd
     */
    public function __construct($bankAcctName = null, $shareSynchInd = null, $shareMarketInd = null, $bankID = null, $acctType = null, $bankAcctNumber = null, $checksAcceptedInd = null)
    {
        $this
            ->setBankAcctName($bankAcctName)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setBankID($bankID)
            ->setAcctType($acctType)
            ->setBankAcctNumber($bankAcctNumber)
            ->setChecksAcceptedInd($checksAcceptedInd);
    }
    /**
     * Get BankAcctName value
     * @return string|null
     */
    public function getBankAcctName()
    {
        return $this->BankAcctName;
    }
    /**
     * Set BankAcctName value
     * @param string $bankAcctName
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setBankAcctName($bankAcctName = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctName) && !is_string($bankAcctName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAcctName)), __LINE__);
        }
        $this->BankAcctName = $bankAcctName;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Get AcctType value
     * @return string|null
     */
    public function getAcctType()
    {
        return $this->AcctType;
    }
    /**
     * Set AcctType value
     * @param string $acctType
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setAcctType($acctType = null)
    {
        // validation for constraint: string
        if (!is_null($acctType) && !is_string($acctType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acctType)), __LINE__);
        }
        $this->AcctType = $acctType;
        return $this;
    }
    /**
     * Get BankAcctNumber value
     * @return string|null
     */
    public function getBankAcctNumber()
    {
        return $this->BankAcctNumber;
    }
    /**
     * Set BankAcctNumber value
     * @param string $bankAcctNumber
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setBankAcctNumber($bankAcctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctNumber) && !is_string($bankAcctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAcctNumber)), __LINE__);
        }
        $this->BankAcctNumber = $bankAcctNumber;
        return $this;
    }
    /**
     * Get ChecksAcceptedInd value
     * @return bool|null
     */
    public function getChecksAcceptedInd()
    {
        return $this->ChecksAcceptedInd;
    }
    /**
     * Set ChecksAcceptedInd value
     * @param bool $checksAcceptedInd
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public function setChecksAcceptedInd($checksAcceptedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($checksAcceptedInd) && !is_bool($checksAcceptedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checksAcceptedInd)), __LINE__);
        }
        $this->ChecksAcceptedInd = $checksAcceptedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBankAcctType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
