<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Availability StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAvailability extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The Restriction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Restriction;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for Availability
     * @uses DgAvailability::setStatus()
     * @uses DgAvailability::setAvailabilityStatus()
     * @uses DgAvailability::setRestriction()
     * @uses DgAvailability::setStart()
     * @uses DgAvailability::setDuration()
     * @uses DgAvailability::setEnd()
     * @param string $status
     * @param string $availabilityStatus
     * @param string[] $restriction
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct($status = null, $availabilityStatus = null, array $restriction = array(), $start = null, $duration = null, $end = null)
    {
        $this
            ->setStatus($status)
            ->setAvailabilityStatus($availabilityStatus)
            ->setRestriction($restriction)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \dgsoft\EnumType\DgAvailabilityStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAvailabilityStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \dgsoft\StructType\DgAvailability
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAvailabilityStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \dgsoft\EnumType\DgAvailabilityStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \dgsoft\EnumType\DgRateIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \dgsoft\StructType\DgAvailability
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \dgsoft\EnumType\DgRateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get Restriction value
     * @return string[]|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @uses \dgsoft\EnumType\DgRestriction::valueIsValid()
     * @uses \dgsoft\EnumType\DgRestriction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $restriction
     * @return \dgsoft\StructType\DgAvailability
     */
    public function setRestriction(array $restriction = array())
    {
        $invalidValues = array();
        foreach ($restriction as $availabilityRestrictionItem) {
            if (!\dgsoft\EnumType\DgRestriction::valueIsValid($availabilityRestrictionItem)) {
                $invalidValues[] = var_export($availabilityRestrictionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgRestriction::getValidValues())), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Add item to Restriction value
     * @uses \dgsoft\EnumType\DgRestriction::valueIsValid()
     * @uses \dgsoft\EnumType\DgRestriction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgAvailability
     */
    public function addToRestriction($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRestriction::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgRestriction::getValidValues())), __LINE__);
        }
        $this->Restriction[] = $item;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgAvailability
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgAvailability
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgAvailability
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAvailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
