<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationSoapHeader StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AuthenticationSoapHeader
 * @package Dg
 * @subpackage Structs
 */
class DgAuthenticationSoapHeader extends AbstractStructBase
{
    /**
     * The WSUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WSUserName;
    /**
     * The WSPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WSPassword;
    /**
     * The WSCultureInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WSCultureInfo;
    /**
     * Constructor method for AuthenticationSoapHeader
     * @uses DgAuthenticationSoapHeader::setWSUserName()
     * @uses DgAuthenticationSoapHeader::setWSPassword()
     * @uses DgAuthenticationSoapHeader::setWSCultureInfo()
     * @param string $wSUserName
     * @param string $wSPassword
     * @param string $wSCultureInfo
     */
    public function __construct($wSUserName = null, $wSPassword = null, $wSCultureInfo = null)
    {
        $this
            ->setWSUserName($wSUserName)
            ->setWSPassword($wSPassword)
            ->setWSCultureInfo($wSCultureInfo);
    }
    /**
     * Get WSUserName value
     * @return string|null
     */
    public function getWSUserName()
    {
        return $this->WSUserName;
    }
    /**
     * Set WSUserName value
     * @param string $wSUserName
     * @return \dgsoft\StructType\DgAuthenticationSoapHeader
     */
    public function setWSUserName($wSUserName = null)
    {
        // validation for constraint: string
        if (!is_null($wSUserName) && !is_string($wSUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wSUserName)), __LINE__);
        }
        $this->WSUserName = $wSUserName;
        return $this;
    }
    /**
     * Get WSPassword value
     * @return string|null
     */
    public function getWSPassword()
    {
        return $this->WSPassword;
    }
    /**
     * Set WSPassword value
     * @param string $wSPassword
     * @return \dgsoft\StructType\DgAuthenticationSoapHeader
     */
    public function setWSPassword($wSPassword = null)
    {
        // validation for constraint: string
        if (!is_null($wSPassword) && !is_string($wSPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wSPassword)), __LINE__);
        }
        $this->WSPassword = $wSPassword;
        return $this;
    }
    /**
     * Get WSCultureInfo value
     * @return string|null
     */
    public function getWSCultureInfo()
    {
        return $this->WSCultureInfo;
    }
    /**
     * Set WSCultureInfo value
     * @param string $wSCultureInfo
     * @return \dgsoft\StructType\DgAuthenticationSoapHeader
     */
    public function setWSCultureInfo($wSCultureInfo = null)
    {
        // validation for constraint: string
        if (!is_null($wSCultureInfo) && !is_string($wSCultureInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wSCultureInfo)), __LINE__);
        }
        $this->WSCultureInfo = $wSCultureInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAuthenticationSoapHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
