<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryTicketFareInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryTicketFareInfoType extends AbstractStructBase
{
    /**
     * The FareTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareTypeCode;
    /**
     * The FareType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareType;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amount;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for AncillaryTicketFareInfoType
     * @uses DgAncillaryTicketFareInfoType::setFareTypeCode()
     * @uses DgAncillaryTicketFareInfoType::setFareType()
     * @uses DgAncillaryTicketFareInfoType::setAmount()
     * @uses DgAncillaryTicketFareInfoType::setCurrency()
     * @param string $fareTypeCode
     * @param string $fareType
     * @param string $amount
     * @param string $currency
     */
    public function __construct($fareTypeCode = null, $fareType = null, $amount = null, $currency = null)
    {
        $this
            ->setFareTypeCode($fareTypeCode)
            ->setFareType($fareType)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get FareTypeCode value
     * @return string|null
     */
    public function getFareTypeCode()
    {
        return $this->FareTypeCode;
    }
    /**
     * Set FareTypeCode value
     * @param string $fareTypeCode
     * @return \dgsoft\StructType\DgAncillaryTicketFareInfoType
     */
    public function setFareTypeCode($fareTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareTypeCode) && !is_string($fareTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareTypeCode)), __LINE__);
        }
        $this->FareTypeCode = $fareTypeCode;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \dgsoft\StructType\DgAncillaryTicketFareInfoType
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \dgsoft\StructType\DgAncillaryTicketFareInfoType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgAncillaryTicketFareInfoType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryTicketFareInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
