<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryTicketCouponType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryTicketCouponType extends AbstractStructBase
{
    /**
     * The CpnNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CpnNumber;
    /**
     * The IssuanceSubCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuanceSubCode;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingAirline;
    /**
     * The OriginDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginDestination;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ConnectionWithEticketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionWithEticketNumber;
    /**
     * The ConnectionWithEticketType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionWithEticketType;
    /**
     * The ConnectionWithEticket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionWithEticket;
    /**
     * The CouponAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CouponAmount;
    /**
     * The CouponCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CouponCurrency;
    /**
     * The CouponValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CouponValue;
    /**
     * The CouponDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryTicketCouponDetailType
     */
    public $CouponDetail;
    /**
     * Constructor method for AncillaryTicketCouponType
     * @uses DgAncillaryTicketCouponType::setCpnNumber()
     * @uses DgAncillaryTicketCouponType::setIssuanceSubCode()
     * @uses DgAncillaryTicketCouponType::setOperatingAirline()
     * @uses DgAncillaryTicketCouponType::setOriginDestination()
     * @uses DgAncillaryTicketCouponType::setStatusCode()
     * @uses DgAncillaryTicketCouponType::setStatus()
     * @uses DgAncillaryTicketCouponType::setConnectionWithEticketNumber()
     * @uses DgAncillaryTicketCouponType::setConnectionWithEticketType()
     * @uses DgAncillaryTicketCouponType::setConnectionWithEticket()
     * @uses DgAncillaryTicketCouponType::setCouponAmount()
     * @uses DgAncillaryTicketCouponType::setCouponCurrency()
     * @uses DgAncillaryTicketCouponType::setCouponValue()
     * @uses DgAncillaryTicketCouponType::setCouponDetail()
     * @param string $cpnNumber
     * @param string $issuanceSubCode
     * @param string $operatingAirline
     * @param string $originDestination
     * @param string $statusCode
     * @param string $status
     * @param string $connectionWithEticketNumber
     * @param string $connectionWithEticketType
     * @param string $connectionWithEticket
     * @param string $couponAmount
     * @param string $couponCurrency
     * @param string $couponValue
     * @param \dgsoft\StructType\DgAncillaryTicketCouponDetailType $couponDetail
     */
    public function __construct($cpnNumber = null, $issuanceSubCode = null, $operatingAirline = null, $originDestination = null, $statusCode = null, $status = null, $connectionWithEticketNumber = null, $connectionWithEticketType = null, $connectionWithEticket = null, $couponAmount = null, $couponCurrency = null, $couponValue = null, \dgsoft\StructType\DgAncillaryTicketCouponDetailType $couponDetail = null)
    {
        $this
            ->setCpnNumber($cpnNumber)
            ->setIssuanceSubCode($issuanceSubCode)
            ->setOperatingAirline($operatingAirline)
            ->setOriginDestination($originDestination)
            ->setStatusCode($statusCode)
            ->setStatus($status)
            ->setConnectionWithEticketNumber($connectionWithEticketNumber)
            ->setConnectionWithEticketType($connectionWithEticketType)
            ->setConnectionWithEticket($connectionWithEticket)
            ->setCouponAmount($couponAmount)
            ->setCouponCurrency($couponCurrency)
            ->setCouponValue($couponValue)
            ->setCouponDetail($couponDetail);
    }
    /**
     * Get CpnNumber value
     * @return string|null
     */
    public function getCpnNumber()
    {
        return $this->CpnNumber;
    }
    /**
     * Set CpnNumber value
     * @param string $cpnNumber
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setCpnNumber($cpnNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cpnNumber) && !is_string($cpnNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cpnNumber)), __LINE__);
        }
        $this->CpnNumber = $cpnNumber;
        return $this;
    }
    /**
     * Get IssuanceSubCode value
     * @return string|null
     */
    public function getIssuanceSubCode()
    {
        return $this->IssuanceSubCode;
    }
    /**
     * Set IssuanceSubCode value
     * @param string $issuanceSubCode
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setIssuanceSubCode($issuanceSubCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuanceSubCode) && !is_string($issuanceSubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuanceSubCode)), __LINE__);
        }
        $this->IssuanceSubCode = $issuanceSubCode;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return string|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param string $operatingAirline
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setOperatingAirline($operatingAirline = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAirline) && !is_string($operatingAirline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingAirline)), __LINE__);
        }
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get OriginDestination value
     * @return string|null
     */
    public function getOriginDestination()
    {
        return $this->OriginDestination;
    }
    /**
     * Set OriginDestination value
     * @param string $originDestination
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setOriginDestination($originDestination = null)
    {
        // validation for constraint: string
        if (!is_null($originDestination) && !is_string($originDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originDestination)), __LINE__);
        }
        $this->OriginDestination = $originDestination;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ConnectionWithEticketNumber value
     * @return string|null
     */
    public function getConnectionWithEticketNumber()
    {
        return $this->ConnectionWithEticketNumber;
    }
    /**
     * Set ConnectionWithEticketNumber value
     * @param string $connectionWithEticketNumber
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setConnectionWithEticketNumber($connectionWithEticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($connectionWithEticketNumber) && !is_string($connectionWithEticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionWithEticketNumber)), __LINE__);
        }
        $this->ConnectionWithEticketNumber = $connectionWithEticketNumber;
        return $this;
    }
    /**
     * Get ConnectionWithEticketType value
     * @return string|null
     */
    public function getConnectionWithEticketType()
    {
        return $this->ConnectionWithEticketType;
    }
    /**
     * Set ConnectionWithEticketType value
     * @param string $connectionWithEticketType
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setConnectionWithEticketType($connectionWithEticketType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionWithEticketType) && !is_string($connectionWithEticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionWithEticketType)), __LINE__);
        }
        $this->ConnectionWithEticketType = $connectionWithEticketType;
        return $this;
    }
    /**
     * Get ConnectionWithEticket value
     * @return string|null
     */
    public function getConnectionWithEticket()
    {
        return $this->ConnectionWithEticket;
    }
    /**
     * Set ConnectionWithEticket value
     * @param string $connectionWithEticket
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setConnectionWithEticket($connectionWithEticket = null)
    {
        // validation for constraint: string
        if (!is_null($connectionWithEticket) && !is_string($connectionWithEticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionWithEticket)), __LINE__);
        }
        $this->ConnectionWithEticket = $connectionWithEticket;
        return $this;
    }
    /**
     * Get CouponAmount value
     * @return string|null
     */
    public function getCouponAmount()
    {
        return $this->CouponAmount;
    }
    /**
     * Set CouponAmount value
     * @param string $couponAmount
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setCouponAmount($couponAmount = null)
    {
        // validation for constraint: string
        if (!is_null($couponAmount) && !is_string($couponAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponAmount)), __LINE__);
        }
        $this->CouponAmount = $couponAmount;
        return $this;
    }
    /**
     * Get CouponCurrency value
     * @return string|null
     */
    public function getCouponCurrency()
    {
        return $this->CouponCurrency;
    }
    /**
     * Set CouponCurrency value
     * @param string $couponCurrency
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setCouponCurrency($couponCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($couponCurrency) && !is_string($couponCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponCurrency)), __LINE__);
        }
        $this->CouponCurrency = $couponCurrency;
        return $this;
    }
    /**
     * Get CouponValue value
     * @return string|null
     */
    public function getCouponValue()
    {
        return $this->CouponValue;
    }
    /**
     * Set CouponValue value
     * @param string $couponValue
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setCouponValue($couponValue = null)
    {
        // validation for constraint: string
        if (!is_null($couponValue) && !is_string($couponValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponValue)), __LINE__);
        }
        $this->CouponValue = $couponValue;
        return $this;
    }
    /**
     * Get CouponDetail value
     * @return \dgsoft\StructType\DgAncillaryTicketCouponDetailType|null
     */
    public function getCouponDetail()
    {
        return $this->CouponDetail;
    }
    /**
     * Set CouponDetail value
     * @param \dgsoft\StructType\DgAncillaryTicketCouponDetailType $couponDetail
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public function setCouponDetail(\dgsoft\StructType\DgAncillaryTicketCouponDetailType $couponDetail = null)
    {
        $this->CouponDetail = $couponDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
