<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryProductType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryProductType extends DgAncillaryProductTypeBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The PricedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PricedAmount;
    /**
     * The PricedAmountInTicketCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PricedAmountInTicketCurrency;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Tax;
    /**
     * The AncillaryProductLineNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AncillaryProductLineNumber;
    /**
     * The PNRPassengerOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PNRPassengerOrderID;
    /**
     * The PNRSegmentOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PNRSegmentOrderID;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The EticketInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public $EticketInfo;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineCode;
    /**
     * The UniqueReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueReference;
    /**
     * Constructor method for AncillaryProductType
     * @uses DgAncillaryProductType::setAmount()
     * @uses DgAncillaryProductType::setPricedAmount()
     * @uses DgAncillaryProductType::setPricedAmountInTicketCurrency()
     * @uses DgAncillaryProductType::setTax()
     * @uses DgAncillaryProductType::setAncillaryProductLineNumber()
     * @uses DgAncillaryProductType::setPNRPassengerOrderID()
     * @uses DgAncillaryProductType::setPNRSegmentOrderID()
     * @uses DgAncillaryProductType::setCurrency()
     * @uses DgAncillaryProductType::setConfirmationNumber()
     * @uses DgAncillaryProductType::setEticketInfo()
     * @uses DgAncillaryProductType::setAirlineCode()
     * @uses DgAncillaryProductType::setUniqueReference()
     * @param float $amount
     * @param float $pricedAmount
     * @param float $pricedAmountInTicketCurrency
     * @param float $tax
     * @param int $ancillaryProductLineNumber
     * @param int $pNRPassengerOrderID
     * @param int $pNRSegmentOrderID
     * @param string $currency
     * @param string $confirmationNumber
     * @param \dgsoft\StructType\DgAncillaryEticketInfoType $eticketInfo
     * @param string $airlineCode
     * @param string $uniqueReference
     */
    public function __construct($amount = null, $pricedAmount = null, $pricedAmountInTicketCurrency = null, $tax = null, $ancillaryProductLineNumber = null, $pNRPassengerOrderID = null, $pNRSegmentOrderID = null, $currency = null, $confirmationNumber = null, \dgsoft\StructType\DgAncillaryEticketInfoType $eticketInfo = null, $airlineCode = null, $uniqueReference = null)
    {
        $this
            ->setAmount($amount)
            ->setPricedAmount($pricedAmount)
            ->setPricedAmountInTicketCurrency($pricedAmountInTicketCurrency)
            ->setTax($tax)
            ->setAncillaryProductLineNumber($ancillaryProductLineNumber)
            ->setPNRPassengerOrderID($pNRPassengerOrderID)
            ->setPNRSegmentOrderID($pNRSegmentOrderID)
            ->setCurrency($currency)
            ->setConfirmationNumber($confirmationNumber)
            ->setEticketInfo($eticketInfo)
            ->setAirlineCode($airlineCode)
            ->setUniqueReference($uniqueReference);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PricedAmount value
     * @return float
     */
    public function getPricedAmount()
    {
        return $this->PricedAmount;
    }
    /**
     * Set PricedAmount value
     * @param float $pricedAmount
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setPricedAmount($pricedAmount = null)
    {
        $this->PricedAmount = $pricedAmount;
        return $this;
    }
    /**
     * Get PricedAmountInTicketCurrency value
     * @return float
     */
    public function getPricedAmountInTicketCurrency()
    {
        return $this->PricedAmountInTicketCurrency;
    }
    /**
     * Set PricedAmountInTicketCurrency value
     * @param float $pricedAmountInTicketCurrency
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setPricedAmountInTicketCurrency($pricedAmountInTicketCurrency = null)
    {
        $this->PricedAmountInTicketCurrency = $pricedAmountInTicketCurrency;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get AncillaryProductLineNumber value
     * @return int
     */
    public function getAncillaryProductLineNumber()
    {
        return $this->AncillaryProductLineNumber;
    }
    /**
     * Set AncillaryProductLineNumber value
     * @param int $ancillaryProductLineNumber
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setAncillaryProductLineNumber($ancillaryProductLineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ancillaryProductLineNumber) && !is_numeric($ancillaryProductLineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ancillaryProductLineNumber)), __LINE__);
        }
        $this->AncillaryProductLineNumber = $ancillaryProductLineNumber;
        return $this;
    }
    /**
     * Get PNRPassengerOrderID value
     * @return int
     */
    public function getPNRPassengerOrderID()
    {
        return $this->PNRPassengerOrderID;
    }
    /**
     * Set PNRPassengerOrderID value
     * @param int $pNRPassengerOrderID
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setPNRPassengerOrderID($pNRPassengerOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($pNRPassengerOrderID) && !is_numeric($pNRPassengerOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pNRPassengerOrderID)), __LINE__);
        }
        $this->PNRPassengerOrderID = $pNRPassengerOrderID;
        return $this;
    }
    /**
     * Get PNRSegmentOrderID value
     * @return int
     */
    public function getPNRSegmentOrderID()
    {
        return $this->PNRSegmentOrderID;
    }
    /**
     * Set PNRSegmentOrderID value
     * @param int $pNRSegmentOrderID
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setPNRSegmentOrderID($pNRSegmentOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($pNRSegmentOrderID) && !is_numeric($pNRSegmentOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pNRSegmentOrderID)), __LINE__);
        }
        $this->PNRSegmentOrderID = $pNRSegmentOrderID;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get EticketInfo value
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType|null
     */
    public function getEticketInfo()
    {
        return $this->EticketInfo;
    }
    /**
     * Set EticketInfo value
     * @param \dgsoft\StructType\DgAncillaryEticketInfoType $eticketInfo
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setEticketInfo(\dgsoft\StructType\DgAncillaryEticketInfoType $eticketInfo = null)
    {
        $this->EticketInfo = $eticketInfo;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get UniqueReference value
     * @return string|null
     */
    public function getUniqueReference()
    {
        return $this->UniqueReference;
    }
    /**
     * Set UniqueReference value
     * @param string $uniqueReference
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public function setUniqueReference($uniqueReference = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueReference) && !is_string($uniqueReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueReference)), __LINE__);
        }
        $this->UniqueReference = $uniqueReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
