<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFareType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryFareType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The XMLPassengerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $XMLPassengerID;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The ItineraryReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItineraryReference;
    /**
     * The SegmentReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentReference;
    /**
     * The SegmentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentInfo;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassengerType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ServiceFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryServiceFeesType
     */
    public $ServiceFees;
    /**
     * Constructor method for AncillaryFareType
     * @uses DgAncillaryFareType::setAmount()
     * @uses DgAncillaryFareType::setTax()
     * @uses DgAncillaryFareType::setXMLPassengerID()
     * @uses DgAncillaryFareType::setCurrency()
     * @uses DgAncillaryFareType::setItineraryReference()
     * @uses DgAncillaryFareType::setSegmentReference()
     * @uses DgAncillaryFareType::setSegmentInfo()
     * @uses DgAncillaryFareType::setPassengerType()
     * @uses DgAncillaryFareType::setDescription()
     * @uses DgAncillaryFareType::setServiceFees()
     * @param float $amount
     * @param float $tax
     * @param int $xMLPassengerID
     * @param string $currency
     * @param string $itineraryReference
     * @param string $segmentReference
     * @param string $segmentInfo
     * @param string $passengerType
     * @param string $description
     * @param \dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees
     */
    public function __construct($amount = null, $tax = null, $xMLPassengerID = null, $currency = null, $itineraryReference = null, $segmentReference = null, $segmentInfo = null, $passengerType = null, $description = null, \dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees = null)
    {
        $this
            ->setAmount($amount)
            ->setTax($tax)
            ->setXMLPassengerID($xMLPassengerID)
            ->setCurrency($currency)
            ->setItineraryReference($itineraryReference)
            ->setSegmentReference($segmentReference)
            ->setSegmentInfo($segmentInfo)
            ->setPassengerType($passengerType)
            ->setDescription($description)
            ->setServiceFees($serviceFees);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get XMLPassengerID value
     * @return int
     */
    public function getXMLPassengerID()
    {
        return $this->XMLPassengerID;
    }
    /**
     * Set XMLPassengerID value
     * @param int $xMLPassengerID
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setXMLPassengerID($xMLPassengerID = null)
    {
        // validation for constraint: int
        if (!is_null($xMLPassengerID) && !is_numeric($xMLPassengerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($xMLPassengerID)), __LINE__);
        }
        $this->XMLPassengerID = $xMLPassengerID;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ItineraryReference value
     * @return string|null
     */
    public function getItineraryReference()
    {
        return $this->ItineraryReference;
    }
    /**
     * Set ItineraryReference value
     * @param string $itineraryReference
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setItineraryReference($itineraryReference = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryReference) && !is_string($itineraryReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itineraryReference)), __LINE__);
        }
        $this->ItineraryReference = $itineraryReference;
        return $this;
    }
    /**
     * Get SegmentReference value
     * @return string|null
     */
    public function getSegmentReference()
    {
        return $this->SegmentReference;
    }
    /**
     * Set SegmentReference value
     * @param string $segmentReference
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setSegmentReference($segmentReference = null)
    {
        // validation for constraint: string
        if (!is_null($segmentReference) && !is_string($segmentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentReference)), __LINE__);
        }
        $this->SegmentReference = $segmentReference;
        return $this;
    }
    /**
     * Get SegmentInfo value
     * @return string|null
     */
    public function getSegmentInfo()
    {
        return $this->SegmentInfo;
    }
    /**
     * Set SegmentInfo value
     * @param string $segmentInfo
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setSegmentInfo($segmentInfo = null)
    {
        // validation for constraint: string
        if (!is_null($segmentInfo) && !is_string($segmentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentInfo)), __LINE__);
        }
        $this->SegmentInfo = $segmentInfo;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ServiceFees value
     * @return \dgsoft\StructType\DgAncillaryServiceFeesType|null
     */
    public function getServiceFees()
    {
        return $this->ServiceFees;
    }
    /**
     * Set ServiceFees value
     * @param \dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public function setServiceFees(\dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees = null)
    {
        $this->ServiceFees = $serviceFees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
