<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryEticketInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryEticketInfoType extends AbstractStructBase
{
    /**
     * The DateOfIssuance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOfIssuance;
    /**
     * The DocumentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNumber;
    /**
     * The IssuanceTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuanceTypeCode;
    /**
     * The IssuanceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuanceType;
    /**
     * The PlaceOfIssue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfIssue;
    /**
     * The InternationalIndicatorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternationalIndicatorCode;
    /**
     * The InternationalIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternationalIndicator;
    /**
     * The IATANumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IATANumber;
    /**
     * The EndorsableCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndorsableCode;
    /**
     * The Endorsable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Endorsable;
    /**
     * The AncillaryTicketRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryTicketRemarkType[]
     */
    public $AncillaryTicketRemark;
    /**
     * The AncillaryTicketCoupon
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryTicketCouponType[]
     */
    public $AncillaryTicketCoupon;
    /**
     * The AncillaryTicketFareInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryTicketFareInfoType[]
     */
    public $AncillaryTicketFareInfo;
    /**
     * The AncillaryTicketFOP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryTicketFOPType
     */
    public $AncillaryTicketFOP;
    /**
     * Constructor method for AncillaryEticketInfoType
     * @uses DgAncillaryEticketInfoType::setDateOfIssuance()
     * @uses DgAncillaryEticketInfoType::setDocumentNumber()
     * @uses DgAncillaryEticketInfoType::setIssuanceTypeCode()
     * @uses DgAncillaryEticketInfoType::setIssuanceType()
     * @uses DgAncillaryEticketInfoType::setPlaceOfIssue()
     * @uses DgAncillaryEticketInfoType::setInternationalIndicatorCode()
     * @uses DgAncillaryEticketInfoType::setInternationalIndicator()
     * @uses DgAncillaryEticketInfoType::setIATANumber()
     * @uses DgAncillaryEticketInfoType::setEndorsableCode()
     * @uses DgAncillaryEticketInfoType::setEndorsable()
     * @uses DgAncillaryEticketInfoType::setAncillaryTicketRemark()
     * @uses DgAncillaryEticketInfoType::setAncillaryTicketCoupon()
     * @uses DgAncillaryEticketInfoType::setAncillaryTicketFareInfo()
     * @uses DgAncillaryEticketInfoType::setAncillaryTicketFOP()
     * @param string $dateOfIssuance
     * @param string $documentNumber
     * @param string $issuanceTypeCode
     * @param string $issuanceType
     * @param string $placeOfIssue
     * @param string $internationalIndicatorCode
     * @param string $internationalIndicator
     * @param string $iATANumber
     * @param string $endorsableCode
     * @param string $endorsable
     * @param \dgsoft\StructType\DgAncillaryTicketRemarkType[] $ancillaryTicketRemark
     * @param \dgsoft\StructType\DgAncillaryTicketCouponType[] $ancillaryTicketCoupon
     * @param \dgsoft\StructType\DgAncillaryTicketFareInfoType[] $ancillaryTicketFareInfo
     * @param \dgsoft\StructType\DgAncillaryTicketFOPType $ancillaryTicketFOP
     */
    public function __construct($dateOfIssuance = null, $documentNumber = null, $issuanceTypeCode = null, $issuanceType = null, $placeOfIssue = null, $internationalIndicatorCode = null, $internationalIndicator = null, $iATANumber = null, $endorsableCode = null, $endorsable = null, array $ancillaryTicketRemark = array(), array $ancillaryTicketCoupon = array(), array $ancillaryTicketFareInfo = array(), \dgsoft\StructType\DgAncillaryTicketFOPType $ancillaryTicketFOP = null)
    {
        $this
            ->setDateOfIssuance($dateOfIssuance)
            ->setDocumentNumber($documentNumber)
            ->setIssuanceTypeCode($issuanceTypeCode)
            ->setIssuanceType($issuanceType)
            ->setPlaceOfIssue($placeOfIssue)
            ->setInternationalIndicatorCode($internationalIndicatorCode)
            ->setInternationalIndicator($internationalIndicator)
            ->setIATANumber($iATANumber)
            ->setEndorsableCode($endorsableCode)
            ->setEndorsable($endorsable)
            ->setAncillaryTicketRemark($ancillaryTicketRemark)
            ->setAncillaryTicketCoupon($ancillaryTicketCoupon)
            ->setAncillaryTicketFareInfo($ancillaryTicketFareInfo)
            ->setAncillaryTicketFOP($ancillaryTicketFOP);
    }
    /**
     * Get DateOfIssuance value
     * @return string
     */
    public function getDateOfIssuance()
    {
        return $this->DateOfIssuance;
    }
    /**
     * Set DateOfIssuance value
     * @param string $dateOfIssuance
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setDateOfIssuance($dateOfIssuance = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssuance) && !is_string($dateOfIssuance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfIssuance)), __LINE__);
        }
        $this->DateOfIssuance = $dateOfIssuance;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get IssuanceTypeCode value
     * @return string|null
     */
    public function getIssuanceTypeCode()
    {
        return $this->IssuanceTypeCode;
    }
    /**
     * Set IssuanceTypeCode value
     * @param string $issuanceTypeCode
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setIssuanceTypeCode($issuanceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuanceTypeCode) && !is_string($issuanceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuanceTypeCode)), __LINE__);
        }
        $this->IssuanceTypeCode = $issuanceTypeCode;
        return $this;
    }
    /**
     * Get IssuanceType value
     * @return string|null
     */
    public function getIssuanceType()
    {
        return $this->IssuanceType;
    }
    /**
     * Set IssuanceType value
     * @param string $issuanceType
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setIssuanceType($issuanceType = null)
    {
        // validation for constraint: string
        if (!is_null($issuanceType) && !is_string($issuanceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuanceType)), __LINE__);
        }
        $this->IssuanceType = $issuanceType;
        return $this;
    }
    /**
     * Get PlaceOfIssue value
     * @return string|null
     */
    public function getPlaceOfIssue()
    {
        return $this->PlaceOfIssue;
    }
    /**
     * Set PlaceOfIssue value
     * @param string $placeOfIssue
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setPlaceOfIssue($placeOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfIssue) && !is_string($placeOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeOfIssue)), __LINE__);
        }
        $this->PlaceOfIssue = $placeOfIssue;
        return $this;
    }
    /**
     * Get InternationalIndicatorCode value
     * @return string|null
     */
    public function getInternationalIndicatorCode()
    {
        return $this->InternationalIndicatorCode;
    }
    /**
     * Set InternationalIndicatorCode value
     * @param string $internationalIndicatorCode
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setInternationalIndicatorCode($internationalIndicatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($internationalIndicatorCode) && !is_string($internationalIndicatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalIndicatorCode)), __LINE__);
        }
        $this->InternationalIndicatorCode = $internationalIndicatorCode;
        return $this;
    }
    /**
     * Get InternationalIndicator value
     * @return string|null
     */
    public function getInternationalIndicator()
    {
        return $this->InternationalIndicator;
    }
    /**
     * Set InternationalIndicator value
     * @param string $internationalIndicator
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setInternationalIndicator($internationalIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($internationalIndicator) && !is_string($internationalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalIndicator)), __LINE__);
        }
        $this->InternationalIndicator = $internationalIndicator;
        return $this;
    }
    /**
     * Get IATANumber value
     * @return string|null
     */
    public function getIATANumber()
    {
        return $this->IATANumber;
    }
    /**
     * Set IATANumber value
     * @param string $iATANumber
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setIATANumber($iATANumber = null)
    {
        // validation for constraint: string
        if (!is_null($iATANumber) && !is_string($iATANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iATANumber)), __LINE__);
        }
        $this->IATANumber = $iATANumber;
        return $this;
    }
    /**
     * Get EndorsableCode value
     * @return string|null
     */
    public function getEndorsableCode()
    {
        return $this->EndorsableCode;
    }
    /**
     * Set EndorsableCode value
     * @param string $endorsableCode
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setEndorsableCode($endorsableCode = null)
    {
        // validation for constraint: string
        if (!is_null($endorsableCode) && !is_string($endorsableCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endorsableCode)), __LINE__);
        }
        $this->EndorsableCode = $endorsableCode;
        return $this;
    }
    /**
     * Get Endorsable value
     * @return string|null
     */
    public function getEndorsable()
    {
        return $this->Endorsable;
    }
    /**
     * Set Endorsable value
     * @param string $endorsable
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setEndorsable($endorsable = null)
    {
        // validation for constraint: string
        if (!is_null($endorsable) && !is_string($endorsable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endorsable)), __LINE__);
        }
        $this->Endorsable = $endorsable;
        return $this;
    }
    /**
     * Get AncillaryTicketRemark value
     * @return \dgsoft\StructType\DgAncillaryTicketRemarkType[]|null
     */
    public function getAncillaryTicketRemark()
    {
        return $this->AncillaryTicketRemark;
    }
    /**
     * Set AncillaryTicketRemark value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryTicketRemarkType[] $ancillaryTicketRemark
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setAncillaryTicketRemark(array $ancillaryTicketRemark = array())
    {
        foreach ($ancillaryTicketRemark as $ancillaryEticketInfoTypeAncillaryTicketRemarkItem) {
            // validation for constraint: itemType
            if (!$ancillaryEticketInfoTypeAncillaryTicketRemarkItem instanceof \dgsoft\StructType\DgAncillaryTicketRemarkType) {
                throw new \InvalidArgumentException(sprintf('The AncillaryTicketRemark property can only contain items of \dgsoft\StructType\DgAncillaryTicketRemarkType, "%s" given', is_object($ancillaryEticketInfoTypeAncillaryTicketRemarkItem) ? get_class($ancillaryEticketInfoTypeAncillaryTicketRemarkItem) : gettype($ancillaryEticketInfoTypeAncillaryTicketRemarkItem)), __LINE__);
            }
        }
        $this->AncillaryTicketRemark = $ancillaryTicketRemark;
        return $this;
    }
    /**
     * Add item to AncillaryTicketRemark value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryTicketRemarkType $item
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function addToAncillaryTicketRemark(\dgsoft\StructType\DgAncillaryTicketRemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAncillaryTicketRemarkType) {
            throw new \InvalidArgumentException(sprintf('The AncillaryTicketRemark property can only contain items of \dgsoft\StructType\DgAncillaryTicketRemarkType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AncillaryTicketRemark[] = $item;
        return $this;
    }
    /**
     * Get AncillaryTicketCoupon value
     * @return \dgsoft\StructType\DgAncillaryTicketCouponType[]|null
     */
    public function getAncillaryTicketCoupon()
    {
        return $this->AncillaryTicketCoupon;
    }
    /**
     * Set AncillaryTicketCoupon value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryTicketCouponType[] $ancillaryTicketCoupon
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setAncillaryTicketCoupon(array $ancillaryTicketCoupon = array())
    {
        foreach ($ancillaryTicketCoupon as $ancillaryEticketInfoTypeAncillaryTicketCouponItem) {
            // validation for constraint: itemType
            if (!$ancillaryEticketInfoTypeAncillaryTicketCouponItem instanceof \dgsoft\StructType\DgAncillaryTicketCouponType) {
                throw new \InvalidArgumentException(sprintf('The AncillaryTicketCoupon property can only contain items of \dgsoft\StructType\DgAncillaryTicketCouponType, "%s" given', is_object($ancillaryEticketInfoTypeAncillaryTicketCouponItem) ? get_class($ancillaryEticketInfoTypeAncillaryTicketCouponItem) : gettype($ancillaryEticketInfoTypeAncillaryTicketCouponItem)), __LINE__);
            }
        }
        $this->AncillaryTicketCoupon = $ancillaryTicketCoupon;
        return $this;
    }
    /**
     * Add item to AncillaryTicketCoupon value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryTicketCouponType $item
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function addToAncillaryTicketCoupon(\dgsoft\StructType\DgAncillaryTicketCouponType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAncillaryTicketCouponType) {
            throw new \InvalidArgumentException(sprintf('The AncillaryTicketCoupon property can only contain items of \dgsoft\StructType\DgAncillaryTicketCouponType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AncillaryTicketCoupon[] = $item;
        return $this;
    }
    /**
     * Get AncillaryTicketFareInfo value
     * @return \dgsoft\StructType\DgAncillaryTicketFareInfoType[]|null
     */
    public function getAncillaryTicketFareInfo()
    {
        return $this->AncillaryTicketFareInfo;
    }
    /**
     * Set AncillaryTicketFareInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryTicketFareInfoType[] $ancillaryTicketFareInfo
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setAncillaryTicketFareInfo(array $ancillaryTicketFareInfo = array())
    {
        foreach ($ancillaryTicketFareInfo as $ancillaryEticketInfoTypeAncillaryTicketFareInfoItem) {
            // validation for constraint: itemType
            if (!$ancillaryEticketInfoTypeAncillaryTicketFareInfoItem instanceof \dgsoft\StructType\DgAncillaryTicketFareInfoType) {
                throw new \InvalidArgumentException(sprintf('The AncillaryTicketFareInfo property can only contain items of \dgsoft\StructType\DgAncillaryTicketFareInfoType, "%s" given', is_object($ancillaryEticketInfoTypeAncillaryTicketFareInfoItem) ? get_class($ancillaryEticketInfoTypeAncillaryTicketFareInfoItem) : gettype($ancillaryEticketInfoTypeAncillaryTicketFareInfoItem)), __LINE__);
            }
        }
        $this->AncillaryTicketFareInfo = $ancillaryTicketFareInfo;
        return $this;
    }
    /**
     * Add item to AncillaryTicketFareInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryTicketFareInfoType $item
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function addToAncillaryTicketFareInfo(\dgsoft\StructType\DgAncillaryTicketFareInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAncillaryTicketFareInfoType) {
            throw new \InvalidArgumentException(sprintf('The AncillaryTicketFareInfo property can only contain items of \dgsoft\StructType\DgAncillaryTicketFareInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AncillaryTicketFareInfo[] = $item;
        return $this;
    }
    /**
     * Get AncillaryTicketFOP value
     * @return \dgsoft\StructType\DgAncillaryTicketFOPType|null
     */
    public function getAncillaryTicketFOP()
    {
        return $this->AncillaryTicketFOP;
    }
    /**
     * Set AncillaryTicketFOP value
     * @param \dgsoft\StructType\DgAncillaryTicketFOPType $ancillaryTicketFOP
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public function setAncillaryTicketFOP(\dgsoft\StructType\DgAncillaryTicketFOPType $ancillaryTicketFOP = null)
    {
        $this->AncillaryTicketFOP = $ancillaryTicketFOP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryEticketInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
