<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryCatalogueItemType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAncillaryCatalogueItemType extends AbstractStructBase
{
    /**
     * The SSRCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSRCode;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineCode;
    /**
     * The AncillaryFares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryFaresType
     */
    public $AncillaryFares;
    /**
     * The RequiredParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRequiredParameter
     */
    public $RequiredParameters;
    /**
     * Constructor method for AncillaryCatalogueItemType
     * @uses DgAncillaryCatalogueItemType::setSSRCode()
     * @uses DgAncillaryCatalogueItemType::setAirlineCode()
     * @uses DgAncillaryCatalogueItemType::setAncillaryFares()
     * @uses DgAncillaryCatalogueItemType::setRequiredParameters()
     * @param string $sSRCode
     * @param string $airlineCode
     * @param \dgsoft\StructType\DgAncillaryFaresType $ancillaryFares
     * @param \dgsoft\ArrayType\DgArrayOfRequiredParameter $requiredParameters
     */
    public function __construct($sSRCode = null, $airlineCode = null, \dgsoft\StructType\DgAncillaryFaresType $ancillaryFares = null, \dgsoft\ArrayType\DgArrayOfRequiredParameter $requiredParameters = null)
    {
        $this
            ->setSSRCode($sSRCode)
            ->setAirlineCode($airlineCode)
            ->setAncillaryFares($ancillaryFares)
            ->setRequiredParameters($requiredParameters);
    }
    /**
     * Get SSRCode value
     * @return string|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \dgsoft\StructType\DgAncillaryCatalogueItemType
     */
    public function setSSRCode($sSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSRCode) && !is_string($sSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSRCode)), __LINE__);
        }
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \dgsoft\StructType\DgAncillaryCatalogueItemType
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get AncillaryFares value
     * @return \dgsoft\StructType\DgAncillaryFaresType|null
     */
    public function getAncillaryFares()
    {
        return $this->AncillaryFares;
    }
    /**
     * Set AncillaryFares value
     * @param \dgsoft\StructType\DgAncillaryFaresType $ancillaryFares
     * @return \dgsoft\StructType\DgAncillaryCatalogueItemType
     */
    public function setAncillaryFares(\dgsoft\StructType\DgAncillaryFaresType $ancillaryFares = null)
    {
        $this->AncillaryFares = $ancillaryFares;
        return $this;
    }
    /**
     * Get RequiredParameters value
     * @return \dgsoft\ArrayType\DgArrayOfRequiredParameter|null
     */
    public function getRequiredParameters()
    {
        return $this->RequiredParameters;
    }
    /**
     * Set RequiredParameters value
     * @param \dgsoft\ArrayType\DgArrayOfRequiredParameter $requiredParameters
     * @return \dgsoft\StructType\DgAncillaryCatalogueItemType
     */
    public function setRequiredParameters(\dgsoft\ArrayType\DgArrayOfRequiredParameter $requiredParameters = null)
    {
        $this->RequiredParameters = $requiredParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAncillaryCatalogueItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
