<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAmountType extends AbstractStructBase
{
    /**
     * The Base
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Base;
    /**
     * The AdditionalGuestAmounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAdditionalGuestAmounts
     */
    public $AdditionalGuestAmounts;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFeeType
     */
    public $Fees;
    /**
     * The CancelPolicies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancelPenaltiesType
     */
    public $CancelPolicies;
    /**
     * The PaymentPolicies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $PaymentPolicies;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDiscount[]
     */
    public $Discount;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Total;
    /**
     * The RateDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $RateDescription;
    /**
     * The AdditionalCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAdditionalCharges
     */
    public $AdditionalCharges;
    /**
     * The AdvanceBookingRestriction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAdvanceBookingRestriction
     */
    public $AdvanceBookingRestriction;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The UnitMultiplier
     * @var int
     */
    public $UnitMultiplier;
    /**
     * The MinGuestApplicable
     * @var int
     */
    public $MinGuestApplicable;
    /**
     * The MaxGuestApplicable
     * @var int
     */
    public $MaxGuestApplicable;
    /**
     * The MinLOS
     * @var int
     */
    public $MinLOS;
    /**
     * The MaxLOS
     * @var int
     */
    public $MaxLOS;
    /**
     * The StayOverDate
     * @var string
     */
    public $StayOverDate;
    /**
     * The AlternateCurrencyInd
     * @var bool
     */
    public $AlternateCurrencyInd;
    /**
     * Constructor method for AmountType
     * @uses DgAmountType::setBase()
     * @uses DgAmountType::setAdditionalGuestAmounts()
     * @uses DgAmountType::setFees()
     * @uses DgAmountType::setCancelPolicies()
     * @uses DgAmountType::setPaymentPolicies()
     * @uses DgAmountType::setDiscount()
     * @uses DgAmountType::setTotal()
     * @uses DgAmountType::setRateDescription()
     * @uses DgAmountType::setAdditionalCharges()
     * @uses DgAmountType::setAdvanceBookingRestriction()
     * @uses DgAmountType::setEffectiveDate()
     * @uses DgAmountType::setExpireDate()
     * @uses DgAmountType::setAgeQualifyingCode()
     * @uses DgAmountType::setMinAge()
     * @uses DgAmountType::setMaxAge()
     * @uses DgAmountType::setAgeTimeUnit()
     * @uses DgAmountType::setGuaranteedInd()
     * @uses DgAmountType::setNumberOfUnits()
     * @uses DgAmountType::setRateTimeUnit()
     * @uses DgAmountType::setUnitMultiplier()
     * @uses DgAmountType::setMinGuestApplicable()
     * @uses DgAmountType::setMaxGuestApplicable()
     * @uses DgAmountType::setMinLOS()
     * @uses DgAmountType::setMaxLOS()
     * @uses DgAmountType::setStayOverDate()
     * @uses DgAmountType::setAlternateCurrencyInd()
     * @param \dgsoft\StructType\DgTotalType $base
     * @param \dgsoft\StructType\DgAdditionalGuestAmounts $additionalGuestAmounts
     * @param \dgsoft\ArrayType\DgArrayOfFeeType $fees
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPolicies
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies
     * @param \dgsoft\StructType\DgDiscount[] $discount
     * @param \dgsoft\StructType\DgTotalType $total
     * @param \dgsoft\StructType\DgParagraphType $rateDescription
     * @param \dgsoft\StructType\DgAdditionalCharges $additionalCharges
     * @param \dgsoft\StructType\DgAdvanceBookingRestriction $advanceBookingRestriction
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param bool $guaranteedInd
     * @param int $numberOfUnits
     * @param string $rateTimeUnit
     * @param int $unitMultiplier
     * @param int $minGuestApplicable
     * @param int $maxGuestApplicable
     * @param int $minLOS
     * @param int $maxLOS
     * @param string $stayOverDate
     * @param bool $alternateCurrencyInd
     */
    public function __construct(\dgsoft\StructType\DgTotalType $base = null, \dgsoft\StructType\DgAdditionalGuestAmounts $additionalGuestAmounts = null, \dgsoft\ArrayType\DgArrayOfFeeType $fees = null, \dgsoft\StructType\DgCancelPenaltiesType $cancelPolicies = null, \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies = null, array $discount = array(), \dgsoft\StructType\DgTotalType $total = null, \dgsoft\StructType\DgParagraphType $rateDescription = null, \dgsoft\StructType\DgAdditionalCharges $additionalCharges = null, \dgsoft\StructType\DgAdvanceBookingRestriction $advanceBookingRestriction = null, $effectiveDate = null, $expireDate = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $guaranteedInd = null, $numberOfUnits = null, $rateTimeUnit = null, $unitMultiplier = null, $minGuestApplicable = null, $maxGuestApplicable = null, $minLOS = null, $maxLOS = null, $stayOverDate = null, $alternateCurrencyInd = null)
    {
        $this
            ->setBase($base)
            ->setAdditionalGuestAmounts($additionalGuestAmounts)
            ->setFees($fees)
            ->setCancelPolicies($cancelPolicies)
            ->setPaymentPolicies($paymentPolicies)
            ->setDiscount($discount)
            ->setTotal($total)
            ->setRateDescription($rateDescription)
            ->setAdditionalCharges($additionalCharges)
            ->setAdvanceBookingRestriction($advanceBookingRestriction)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setGuaranteedInd($guaranteedInd)
            ->setNumberOfUnits($numberOfUnits)
            ->setRateTimeUnit($rateTimeUnit)
            ->setUnitMultiplier($unitMultiplier)
            ->setMinGuestApplicable($minGuestApplicable)
            ->setMaxGuestApplicable($maxGuestApplicable)
            ->setMinLOS($minLOS)
            ->setMaxLOS($maxLOS)
            ->setStayOverDate($stayOverDate)
            ->setAlternateCurrencyInd($alternateCurrencyInd);
    }
    /**
     * Get Base value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getBase()
    {
        return $this->Base;
    }
    /**
     * Set Base value
     * @param \dgsoft\StructType\DgTotalType $base
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setBase(\dgsoft\StructType\DgTotalType $base = null)
    {
        $this->Base = $base;
        return $this;
    }
    /**
     * Get AdditionalGuestAmounts value
     * @return \dgsoft\StructType\DgAdditionalGuestAmounts|null
     */
    public function getAdditionalGuestAmounts()
    {
        return $this->AdditionalGuestAmounts;
    }
    /**
     * Set AdditionalGuestAmounts value
     * @param \dgsoft\StructType\DgAdditionalGuestAmounts $additionalGuestAmounts
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setAdditionalGuestAmounts(\dgsoft\StructType\DgAdditionalGuestAmounts $additionalGuestAmounts = null)
    {
        $this->AdditionalGuestAmounts = $additionalGuestAmounts;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\ArrayType\DgArrayOfFeeType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\ArrayType\DgArrayOfFeeType $fees
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setFees(\dgsoft\ArrayType\DgArrayOfFeeType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get CancelPolicies value
     * @return \dgsoft\StructType\DgCancelPenaltiesType|null
     */
    public function getCancelPolicies()
    {
        return $this->CancelPolicies;
    }
    /**
     * Set CancelPolicies value
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPolicies
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setCancelPolicies(\dgsoft\StructType\DgCancelPenaltiesType $cancelPolicies = null)
    {
        $this->CancelPolicies = $cancelPolicies;
        return $this;
    }
    /**
     * Get PaymentPolicies value
     * @return \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getPaymentPolicies()
    {
        return $this->PaymentPolicies;
    }
    /**
     * Set PaymentPolicies value
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setPaymentPolicies(\dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $paymentPolicies = null)
    {
        $this->PaymentPolicies = $paymentPolicies;
        return $this;
    }
    /**
     * Get Discount value
     * @return \dgsoft\StructType\DgDiscount[]|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDiscount[] $discount
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setDiscount(array $discount = array())
    {
        foreach ($discount as $amountTypeDiscountItem) {
            // validation for constraint: itemType
            if (!$amountTypeDiscountItem instanceof \dgsoft\StructType\DgDiscount) {
                throw new \InvalidArgumentException(sprintf('The Discount property can only contain items of \dgsoft\StructType\DgDiscount, "%s" given', is_object($amountTypeDiscountItem) ? get_class($amountTypeDiscountItem) : gettype($amountTypeDiscountItem)), __LINE__);
            }
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Add item to Discount value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDiscount $item
     * @return \dgsoft\StructType\DgAmountType
     */
    public function addToDiscount(\dgsoft\StructType\DgDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDiscount) {
            throw new \InvalidArgumentException(sprintf('The Discount property can only contain items of \dgsoft\StructType\DgDiscount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Discount[] = $item;
        return $this;
    }
    /**
     * Get Total value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \dgsoft\StructType\DgTotalType $total
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setTotal(\dgsoft\StructType\DgTotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get RateDescription value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getRateDescription()
    {
        return $this->RateDescription;
    }
    /**
     * Set RateDescription value
     * @param \dgsoft\StructType\DgParagraphType $rateDescription
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setRateDescription(\dgsoft\StructType\DgParagraphType $rateDescription = null)
    {
        $this->RateDescription = $rateDescription;
        return $this;
    }
    /**
     * Get AdditionalCharges value
     * @return \dgsoft\StructType\DgAdditionalCharges|null
     */
    public function getAdditionalCharges()
    {
        return $this->AdditionalCharges;
    }
    /**
     * Set AdditionalCharges value
     * @param \dgsoft\StructType\DgAdditionalCharges $additionalCharges
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setAdditionalCharges(\dgsoft\StructType\DgAdditionalCharges $additionalCharges = null)
    {
        $this->AdditionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Get AdvanceBookingRestriction value
     * @return \dgsoft\StructType\DgAdvanceBookingRestriction|null
     */
    public function getAdvanceBookingRestriction()
    {
        return $this->AdvanceBookingRestriction;
    }
    /**
     * Set AdvanceBookingRestriction value
     * @param \dgsoft\StructType\DgAdvanceBookingRestriction $advanceBookingRestriction
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setAdvanceBookingRestriction(\dgsoft\StructType\DgAdvanceBookingRestriction $advanceBookingRestriction = null)
    {
        $this->AdvanceBookingRestriction = $advanceBookingRestriction;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !is_numeric($minAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !is_numeric($maxAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ageTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !is_numeric($numberOfUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rateTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get UnitMultiplier value
     * @return int|null
     */
    public function getUnitMultiplier()
    {
        return $this->UnitMultiplier;
    }
    /**
     * Set UnitMultiplier value
     * @param int $unitMultiplier
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setUnitMultiplier($unitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($unitMultiplier) && !is_numeric($unitMultiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitMultiplier)), __LINE__);
        }
        $this->UnitMultiplier = $unitMultiplier;
        return $this;
    }
    /**
     * Get MinGuestApplicable value
     * @return int|null
     */
    public function getMinGuestApplicable()
    {
        return $this->MinGuestApplicable;
    }
    /**
     * Set MinGuestApplicable value
     * @param int $minGuestApplicable
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setMinGuestApplicable($minGuestApplicable = null)
    {
        // validation for constraint: int
        if (!is_null($minGuestApplicable) && !is_numeric($minGuestApplicable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minGuestApplicable)), __LINE__);
        }
        $this->MinGuestApplicable = $minGuestApplicable;
        return $this;
    }
    /**
     * Get MaxGuestApplicable value
     * @return int|null
     */
    public function getMaxGuestApplicable()
    {
        return $this->MaxGuestApplicable;
    }
    /**
     * Set MaxGuestApplicable value
     * @param int $maxGuestApplicable
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setMaxGuestApplicable($maxGuestApplicable = null)
    {
        // validation for constraint: int
        if (!is_null($maxGuestApplicable) && !is_numeric($maxGuestApplicable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxGuestApplicable)), __LINE__);
        }
        $this->MaxGuestApplicable = $maxGuestApplicable;
        return $this;
    }
    /**
     * Get MinLOS value
     * @return int|null
     */
    public function getMinLOS()
    {
        return $this->MinLOS;
    }
    /**
     * Set MinLOS value
     * @param int $minLOS
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setMinLOS($minLOS = null)
    {
        // validation for constraint: int
        if (!is_null($minLOS) && !is_numeric($minLOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minLOS)), __LINE__);
        }
        $this->MinLOS = $minLOS;
        return $this;
    }
    /**
     * Get MaxLOS value
     * @return int|null
     */
    public function getMaxLOS()
    {
        return $this->MaxLOS;
    }
    /**
     * Set MaxLOS value
     * @param int $maxLOS
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setMaxLOS($maxLOS = null)
    {
        // validation for constraint: int
        if (!is_null($maxLOS) && !is_numeric($maxLOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLOS)), __LINE__);
        }
        $this->MaxLOS = $maxLOS;
        return $this;
    }
    /**
     * Get StayOverDate value
     * @return string|null
     */
    public function getStayOverDate()
    {
        return $this->StayOverDate;
    }
    /**
     * Set StayOverDate value
     * @uses \dgsoft\EnumType\DgDayOfWeekType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayOverDate
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setStayOverDate($stayOverDate = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDayOfWeekType::valueIsValid($stayOverDate)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stayOverDate, implode(', ', \dgsoft\EnumType\DgDayOfWeekType::getValidValues())), __LINE__);
        }
        $this->StayOverDate = $stayOverDate;
        return $this;
    }
    /**
     * Get AlternateCurrencyInd value
     * @return bool|null
     */
    public function getAlternateCurrencyInd()
    {
        return $this->AlternateCurrencyInd;
    }
    /**
     * Set AlternateCurrencyInd value
     * @param bool $alternateCurrencyInd
     * @return \dgsoft\StructType\DgAmountType
     */
    public function setAlternateCurrencyInd($alternateCurrencyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($alternateCurrencyInd) && !is_bool($alternateCurrencyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alternateCurrencyInd)), __LINE__);
        }
        $this->AlternateCurrencyInd = $alternateCurrencyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
