<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountPercentType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAmountPercentType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTaxesType
     */
    public $Taxes;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The FeesInclusive
     * @var bool
     */
    public $FeesInclusive;
    /**
     * The NmbrOfNights
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The BasisType
     * @var string
     */
    public $BasisType;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ApplyAs
     * @var string
     */
    public $ApplyAs;
    /**
     * Constructor method for AmountPercentType
     * @uses DgAmountPercentType::setTaxes()
     * @uses DgAmountPercentType::setTaxInclusive()
     * @uses DgAmountPercentType::setFeesInclusive()
     * @uses DgAmountPercentType::setNmbrOfNights()
     * @uses DgAmountPercentType::setBasisType()
     * @uses DgAmountPercentType::setPercent()
     * @uses DgAmountPercentType::setAmount()
     * @uses DgAmountPercentType::setApplyAs()
     * @param \dgsoft\StructType\DgTaxesType $taxes
     * @param bool $taxInclusive
     * @param bool $feesInclusive
     * @param int $nmbrOfNights
     * @param string $basisType
     * @param float $percent
     * @param float $amount
     * @param string $applyAs
     */
    public function __construct(\dgsoft\StructType\DgTaxesType $taxes = null, $taxInclusive = null, $feesInclusive = null, $nmbrOfNights = null, $basisType = null, $percent = null, $amount = null, $applyAs = null)
    {
        $this
            ->setTaxes($taxes)
            ->setTaxInclusive($taxInclusive)
            ->setFeesInclusive($feesInclusive)
            ->setNmbrOfNights($nmbrOfNights)
            ->setBasisType($basisType)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setApplyAs($applyAs);
    }
    /**
     * Get Taxes value
     * @return \dgsoft\StructType\DgTaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \dgsoft\StructType\DgTaxesType $taxes
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setTaxes(\dgsoft\StructType\DgTaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get FeesInclusive value
     * @return bool|null
     */
    public function getFeesInclusive()
    {
        return $this->FeesInclusive;
    }
    /**
     * Set FeesInclusive value
     * @param bool $feesInclusive
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setFeesInclusive($feesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($feesInclusive) && !is_bool($feesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($feesInclusive)), __LINE__);
        }
        $this->FeesInclusive = $feesInclusive;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !is_numeric($nmbrOfNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get BasisType value
     * @return string|null
     */
    public function getBasisType()
    {
        return $this->BasisType;
    }
    /**
     * Set BasisType value
     * @param string $basisType
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setBasisType($basisType = null)
    {
        // validation for constraint: string
        if (!is_null($basisType) && !is_string($basisType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basisType)), __LINE__);
        }
        $this->BasisType = $basisType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApplyAs value
     * @return string|null
     */
    public function getApplyAs()
    {
        return $this->ApplyAs;
    }
    /**
     * Set ApplyAs value
     * @param string $applyAs
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public function setApplyAs($applyAs = null)
    {
        // validation for constraint: string
        if (!is_null($applyAs) && !is_string($applyAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applyAs)), __LINE__);
        }
        $this->ApplyAs = $applyAs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAmountPercentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
