<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmadeusAPICommandRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAmadeusAPICommandRQ extends AbstractStructBase
{
    /**
     * The Command
     * @var string
     */
    public $Command;
    /**
     * The Server
     * @var string
     */
    public $Server;
    /**
     * The PortNumber
     * @var string
     */
    public $PortNumber;
    /**
     * The CorporateId
     * @var string
     */
    public $CorporateId;
    /**
     * The UserId
     * @var string
     */
    public $UserId;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for AmadeusAPICommandRQ
     * @uses DgAmadeusAPICommandRQ::setCommand()
     * @uses DgAmadeusAPICommandRQ::setServer()
     * @uses DgAmadeusAPICommandRQ::setPortNumber()
     * @uses DgAmadeusAPICommandRQ::setCorporateId()
     * @uses DgAmadeusAPICommandRQ::setUserId()
     * @uses DgAmadeusAPICommandRQ::setPassword()
     * @param string $command
     * @param string $server
     * @param string $portNumber
     * @param string $corporateId
     * @param string $userId
     * @param string $password
     */
    public function __construct($command = null, $server = null, $portNumber = null, $corporateId = null, $userId = null, $password = null)
    {
        $this
            ->setCommand($command)
            ->setServer($server)
            ->setPortNumber($portNumber)
            ->setCorporateId($corporateId)
            ->setUserId($userId)
            ->setPassword($password);
    }
    /**
     * Get Command value
     * @return string|null
     */
    public function getCommand()
    {
        return $this->Command;
    }
    /**
     * Set Command value
     * @param string $command
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($command)), __LINE__);
        }
        $this->Command = $command;
        return $this;
    }
    /**
     * Get Server value
     * @return string|null
     */
    public function getServer()
    {
        return $this->Server;
    }
    /**
     * Set Server value
     * @param string $server
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public function setServer($server = null)
    {
        // validation for constraint: string
        if (!is_null($server) && !is_string($server)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($server)), __LINE__);
        }
        $this->Server = $server;
        return $this;
    }
    /**
     * Get PortNumber value
     * @return string|null
     */
    public function getPortNumber()
    {
        return $this->PortNumber;
    }
    /**
     * Set PortNumber value
     * @param string $portNumber
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public function setPortNumber($portNumber = null)
    {
        // validation for constraint: string
        if (!is_null($portNumber) && !is_string($portNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portNumber)), __LINE__);
        }
        $this->PortNumber = $portNumber;
        return $this;
    }
    /**
     * Get CorporateId value
     * @return string|null
     */
    public function getCorporateId()
    {
        return $this->CorporateId;
    }
    /**
     * Set CorporateId value
     * @param string $corporateId
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public function setCorporateId($corporateId = null)
    {
        // validation for constraint: string
        if (!is_null($corporateId) && !is_string($corporateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corporateId)), __LINE__);
        }
        $this->CorporateId = $corporateId;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAmadeusAPICommandRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
