<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateLocationInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAlternateLocationInfo extends AbstractStructBase
{
    /**
     * The OriginLocation
     * @var string
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var string
     */
    public $DestinationLocation;
    /**
     * Constructor method for AlternateLocationInfo
     * @uses DgAlternateLocationInfo::setOriginLocation()
     * @uses DgAlternateLocationInfo::setDestinationLocation()
     * @param string $originLocation
     * @param string $destinationLocation
     */
    public function __construct($originLocation = null, $destinationLocation = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation);
    }
    /**
     * Get OriginLocation value
     * @return string|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param string $originLocation
     * @return \dgsoft\StructType\DgAlternateLocationInfo
     */
    public function setOriginLocation($originLocation = null)
    {
        // validation for constraint: string
        if (!is_null($originLocation) && !is_string($originLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originLocation)), __LINE__);
        }
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return string|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param string $destinationLocation
     * @return \dgsoft\StructType\DgAlternateLocationInfo
     */
    public function setDestinationLocation($destinationLocation = null)
    {
        // validation for constraint: string
        if (!is_null($destinationLocation) && !is_string($destinationLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationLocation)), __LINE__);
        }
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAlternateLocationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
