<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airport StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirport extends AbstractStructBase
{
    /**
     * The LocationCode
     * @var string
     */
    public $LocationCode;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - default: IATA
     * @var string
     */
    public $CodeContext;
    /**
     * The AirportName
     * @var string
     */
    public $AirportName;
    /**
     * Constructor method for Airport
     * @uses DgAirport::setLocationCode()
     * @uses DgAirport::setCodeContext()
     * @uses DgAirport::setAirportName()
     * @param string $locationCode
     * @param string $codeContext
     * @param string $airportName
     */
    public function __construct($locationCode = null, $codeContext = 'IATA', $airportName = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setCodeContext($codeContext)
            ->setAirportName($airportName);
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \dgsoft\StructType\DgAirport
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \dgsoft\StructType\DgAirport
     */
    public function setCodeContext($codeContext = 'IATA')
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get AirportName value
     * @return string|null
     */
    public function getAirportName()
    {
        return $this->AirportName;
    }
    /**
     * Set AirportName value
     * @param string $airportName
     * @return \dgsoft\StructType\DgAirport
     */
    public function setAirportName($airportName = null)
    {
        // validation for constraint: string
        if (!is_null($airportName) && !is_string($airportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airportName)), __LINE__);
        }
        $this->AirportName = $airportName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
