<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlinePrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirlinePrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The AirportOriginPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirportPrefType[]
     */
    public $AirportOriginPref;
    /**
     * The AirportRoutePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirportPrefType[]
     */
    public $AirportRoutePref;
    /**
     * The FareRestrictPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCabinPref[]
     */
    public $CabinPref;
    /**
     * The SeatPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSeatPref[]
     */
    public $SeatPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMealPrefType[]
     */
    public $MealPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The SSR_Pref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSSR_Pref[]
     */
    public $SSR_Pref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AirTicketType
     * @var string
     */
    public $AirTicketType;
    /**
     * Constructor method for AirlinePrefType
     * @uses DgAirlinePrefType::setLoyaltyPref()
     * @uses DgAirlinePrefType::setVendorPref()
     * @uses DgAirlinePrefType::setPaymentFormPref()
     * @uses DgAirlinePrefType::setAirportOriginPref()
     * @uses DgAirlinePrefType::setAirportRoutePref()
     * @uses DgAirlinePrefType::setFareRestrictPref()
     * @uses DgAirlinePrefType::setFlightTypePref()
     * @uses DgAirlinePrefType::setEquipPref()
     * @uses DgAirlinePrefType::setCabinPref()
     * @uses DgAirlinePrefType::setSeatPref()
     * @uses DgAirlinePrefType::setTicketDistribPref()
     * @uses DgAirlinePrefType::setMealPref()
     * @uses DgAirlinePrefType::setSpecRequestPref()
     * @uses DgAirlinePrefType::setSSR_Pref()
     * @uses DgAirlinePrefType::setTPA_Extensions()
     * @uses DgAirlinePrefType::setMediaEntertainPref()
     * @uses DgAirlinePrefType::setPetInfoPref()
     * @uses DgAirlinePrefType::setShareSynchInd()
     * @uses DgAirlinePrefType::setShareMarketInd()
     * @uses DgAirlinePrefType::setPreferLevel()
     * @uses DgAirlinePrefType::setSmokingAllowed()
     * @uses DgAirlinePrefType::setPassengerTypeCode()
     * @uses DgAirlinePrefType::setAirTicketType()
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @param \dgsoft\StructType\DgAirportPrefType[] $airportOriginPref
     * @param \dgsoft\StructType\DgAirportPrefType[] $airportRoutePref
     * @param \dgsoft\StructType\DgFareRestrictPref[] $fareRestrictPref
     * @param \dgsoft\StructType\DgFlightTypePref[] $flightTypePref
     * @param \dgsoft\StructType\DgEquipmentTypePref[] $equipPref
     * @param \dgsoft\StructType\DgCabinPref[] $cabinPref
     * @param \dgsoft\StructType\DgSeatPref[] $seatPref
     * @param \dgsoft\StructType\DgTicketDistribPrefType[] $ticketDistribPref
     * @param \dgsoft\StructType\DgMealPrefType[] $mealPref
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @param \dgsoft\StructType\DgSSR_Pref[] $sSR_Pref
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param \dgsoft\StructType\DgMediaEntertainPrefType[] $mediaEntertainPref
     * @param \dgsoft\StructType\DgPetInfoPrefType[] $petInfoPref
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $preferLevel
     * @param bool $smokingAllowed
     * @param string $passengerTypeCode
     * @param string $airTicketType
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $airportOriginPref = array(), array $airportRoutePref = array(), array $fareRestrictPref = array(), array $flightTypePref = array(), array $equipPref = array(), array $cabinPref = array(), array $seatPref = array(), array $ticketDistribPref = array(), array $mealPref = array(), array $specRequestPref = array(), array $sSR_Pref = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, array $mediaEntertainPref = array(), array $petInfoPref = array(), $shareSynchInd = null, $shareMarketInd = null, $preferLevel = 'Preferred', $smokingAllowed = false, $passengerTypeCode = null, $airTicketType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setAirportOriginPref($airportOriginPref)
            ->setAirportRoutePref($airportRoutePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setSeatPref($seatPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMealPref($mealPref)
            ->setSpecRequestPref($specRequestPref)
            ->setSSR_Pref($sSR_Pref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPreferLevel($preferLevel)
            ->setSmokingAllowed($smokingAllowed)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAirTicketType($airTicketType);
    }
    /**
     * Get LoyaltyPref value
     * @return \dgsoft\StructType\DgLoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $airlinePrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeLoyaltyPrefItem instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($airlinePrefTypeLoyaltyPrefItem) ? get_class($airlinePrefTypeLoyaltyPrefItem) : gettype($airlinePrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToLoyaltyPref(\dgsoft\StructType\DgLoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgCompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $airlinePrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeVendorPrefItem instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($airlinePrefTypeVendorPrefItem) ? get_class($airlinePrefTypeVendorPrefItem) : gettype($airlinePrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToVendorPref(\dgsoft\StructType\DgCompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \dgsoft\StructType\DgPaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $airlinePrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePaymentFormPrefItem instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($airlinePrefTypePaymentFormPrefItem) ? get_class($airlinePrefTypePaymentFormPrefItem) : gettype($airlinePrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToPaymentFormPref(\dgsoft\StructType\DgPaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get AirportOriginPref value
     * @return \dgsoft\StructType\DgAirportPrefType[]|null
     */
    public function getAirportOriginPref()
    {
        return $this->AirportOriginPref;
    }
    /**
     * Set AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirportPrefType[] $airportOriginPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setAirportOriginPref(array $airportOriginPref = array())
    {
        foreach ($airportOriginPref as $airlinePrefTypeAirportOriginPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportOriginPrefItem instanceof \dgsoft\StructType\DgAirportPrefType) {
                throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of \dgsoft\StructType\DgAirportPrefType, "%s" given', is_object($airlinePrefTypeAirportOriginPrefItem) ? get_class($airlinePrefTypeAirportOriginPrefItem) : gettype($airlinePrefTypeAirportOriginPrefItem)), __LINE__);
            }
        }
        $this->AirportOriginPref = $airportOriginPref;
        return $this;
    }
    /**
     * Add item to AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirportPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToAirportOriginPref(\dgsoft\StructType\DgAirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of \dgsoft\StructType\DgAirportPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportOriginPref[] = $item;
        return $this;
    }
    /**
     * Get AirportRoutePref value
     * @return \dgsoft\StructType\DgAirportPrefType[]|null
     */
    public function getAirportRoutePref()
    {
        return $this->AirportRoutePref;
    }
    /**
     * Set AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirportPrefType[] $airportRoutePref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setAirportRoutePref(array $airportRoutePref = array())
    {
        foreach ($airportRoutePref as $airlinePrefTypeAirportRoutePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportRoutePrefItem instanceof \dgsoft\StructType\DgAirportPrefType) {
                throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of \dgsoft\StructType\DgAirportPrefType, "%s" given', is_object($airlinePrefTypeAirportRoutePrefItem) ? get_class($airlinePrefTypeAirportRoutePrefItem) : gettype($airlinePrefTypeAirportRoutePrefItem)), __LINE__);
            }
        }
        $this->AirportRoutePref = $airportRoutePref;
        return $this;
    }
    /**
     * Add item to AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirportPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToAirportRoutePref(\dgsoft\StructType\DgAirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of \dgsoft\StructType\DgAirportPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportRoutePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \dgsoft\StructType\DgFareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRestrictPref[] $fareRestrictPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        foreach ($fareRestrictPref as $airlinePrefTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFareRestrictPrefItem instanceof \dgsoft\StructType\DgFareRestrictPref) {
                throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \dgsoft\StructType\DgFareRestrictPref, "%s" given', is_object($airlinePrefTypeFareRestrictPrefItem) ? get_class($airlinePrefTypeFareRestrictPrefItem) : gettype($airlinePrefTypeFareRestrictPrefItem)), __LINE__);
            }
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRestrictPref $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToFareRestrictPref(\dgsoft\StructType\DgFareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \dgsoft\StructType\DgFareRestrictPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \dgsoft\StructType\DgFlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightTypePref[] $flightTypePref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        foreach ($flightTypePref as $airlinePrefTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFlightTypePrefItem instanceof \dgsoft\StructType\DgFlightTypePref) {
                throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \dgsoft\StructType\DgFlightTypePref, "%s" given', is_object($airlinePrefTypeFlightTypePrefItem) ? get_class($airlinePrefTypeFlightTypePrefItem) : gettype($airlinePrefTypeFlightTypePrefItem)), __LINE__);
            }
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFlightTypePref $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToFlightTypePref(\dgsoft\StructType\DgFlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \dgsoft\StructType\DgFlightTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \dgsoft\StructType\DgEquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentTypePref[] $equipPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setEquipPref(array $equipPref = array())
    {
        foreach ($equipPref as $airlinePrefTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeEquipPrefItem instanceof \dgsoft\StructType\DgEquipmentTypePref) {
                throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \dgsoft\StructType\DgEquipmentTypePref, "%s" given', is_object($airlinePrefTypeEquipPrefItem) ? get_class($airlinePrefTypeEquipPrefItem) : gettype($airlinePrefTypeEquipPrefItem)), __LINE__);
            }
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentTypePref $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToEquipPref(\dgsoft\StructType\DgEquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \dgsoft\StructType\DgEquipmentTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \dgsoft\StructType\DgCabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinPref[] $cabinPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        foreach ($cabinPref as $airlinePrefTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeCabinPrefItem instanceof \dgsoft\StructType\DgCabinPref) {
                throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \dgsoft\StructType\DgCabinPref, "%s" given', is_object($airlinePrefTypeCabinPrefItem) ? get_class($airlinePrefTypeCabinPrefItem) : gettype($airlinePrefTypeCabinPrefItem)), __LINE__);
            }
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinPref $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToCabinPref(\dgsoft\StructType\DgCabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \dgsoft\StructType\DgCabinPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get SeatPref value
     * @return \dgsoft\StructType\DgSeatPref[]|null
     */
    public function getSeatPref()
    {
        return $this->SeatPref;
    }
    /**
     * Set SeatPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSeatPref[] $seatPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setSeatPref(array $seatPref = array())
    {
        foreach ($seatPref as $airlinePrefTypeSeatPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSeatPrefItem instanceof \dgsoft\StructType\DgSeatPref) {
                throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of \dgsoft\StructType\DgSeatPref, "%s" given', is_object($airlinePrefTypeSeatPrefItem) ? get_class($airlinePrefTypeSeatPrefItem) : gettype($airlinePrefTypeSeatPrefItem)), __LINE__);
            }
        }
        $this->SeatPref = $seatPref;
        return $this;
    }
    /**
     * Add item to SeatPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSeatPref $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToSeatPref(\dgsoft\StructType\DgSeatPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSeatPref) {
            throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of \dgsoft\StructType\DgSeatPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \dgsoft\StructType\DgTicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketDistribPrefType[] $ticketDistribPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        foreach ($ticketDistribPref as $airlinePrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeTicketDistribPrefItem instanceof \dgsoft\StructType\DgTicketDistribPrefType) {
                throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \dgsoft\StructType\DgTicketDistribPrefType, "%s" given', is_object($airlinePrefTypeTicketDistribPrefItem) ? get_class($airlinePrefTypeTicketDistribPrefItem) : gettype($airlinePrefTypeTicketDistribPrefItem)), __LINE__);
            }
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketDistribPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToTicketDistribPref(\dgsoft\StructType\DgTicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \dgsoft\StructType\DgTicketDistribPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \dgsoft\StructType\DgMealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMealPrefType[] $mealPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $airlinePrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMealPrefItem instanceof \dgsoft\StructType\DgMealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \dgsoft\StructType\DgMealPrefType, "%s" given', is_object($airlinePrefTypeMealPrefItem) ? get_class($airlinePrefTypeMealPrefItem) : gettype($airlinePrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMealPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToMealPref(\dgsoft\StructType\DgMealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \dgsoft\StructType\DgMealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \dgsoft\StructType\DgSpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $airlinePrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSpecRequestPrefItem instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($airlinePrefTypeSpecRequestPrefItem) ? get_class($airlinePrefTypeSpecRequestPrefItem) : gettype($airlinePrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToSpecRequestPref(\dgsoft\StructType\DgSpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get SSR_Pref value
     * @return \dgsoft\StructType\DgSSR_Pref[]|null
     */
    public function getSSR_Pref()
    {
        return $this->SSR_Pref;
    }
    /**
     * Set SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSSR_Pref[] $sSR_Pref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setSSR_Pref(array $sSR_Pref = array())
    {
        foreach ($sSR_Pref as $airlinePrefTypeSSR_PrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSSR_PrefItem instanceof \dgsoft\StructType\DgSSR_Pref) {
                throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of \dgsoft\StructType\DgSSR_Pref, "%s" given', is_object($airlinePrefTypeSSR_PrefItem) ? get_class($airlinePrefTypeSSR_PrefItem) : gettype($airlinePrefTypeSSR_PrefItem)), __LINE__);
            }
        }
        $this->SSR_Pref = $sSR_Pref;
        return $this;
    }
    /**
     * Add item to SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSSR_Pref $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToSSR_Pref(\dgsoft\StructType\DgSSR_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSSR_Pref) {
            throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of \dgsoft\StructType\DgSSR_Pref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SSR_Pref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \dgsoft\StructType\DgMediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMediaEntertainPrefType[] $mediaEntertainPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $airlinePrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMediaEntertainPrefItem instanceof \dgsoft\StructType\DgMediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \dgsoft\StructType\DgMediaEntertainPrefType, "%s" given', is_object($airlinePrefTypeMediaEntertainPrefItem) ? get_class($airlinePrefTypeMediaEntertainPrefItem) : gettype($airlinePrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMediaEntertainPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToMediaEntertainPref(\dgsoft\StructType\DgMediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \dgsoft\StructType\DgMediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \dgsoft\StructType\DgPetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPetInfoPrefType[] $petInfoPref
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $airlinePrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePetInfoPrefItem instanceof \dgsoft\StructType\DgPetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \dgsoft\StructType\DgPetInfoPrefType, "%s" given', is_object($airlinePrefTypePetInfoPrefItem) ? get_class($airlinePrefTypePetInfoPrefItem) : gettype($airlinePrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPetInfoPrefType $item
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function addToPetInfoPref(\dgsoft\StructType\DgPetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \dgsoft\StructType\DgPetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AirTicketType value
     * @return string|null
     */
    public function getAirTicketType()
    {
        return $this->AirTicketType;
    }
    /**
     * Set AirTicketType value
     * @uses \dgsoft\EnumType\DgTicketType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airTicketType
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public function setAirTicketType($airTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTicketType::valueIsValid($airTicketType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airTicketType, implode(', ', \dgsoft\EnumType\DgTicketType::getValidValues())), __LINE__);
        }
        $this->AirTicketType = $airTicketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirlinePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
