<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirTravelerType extends AbstractStructBase
{
    /**
     * The NumberOfBaggages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfBaggages;
    /**
     * The NumberOfBaggages1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfBaggages1;
    /**
     * The HandLuggages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HandLuggages;
    /**
     * The HandLuggages1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HandLuggages1;
    /**
     * The LCCParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLCCParameters
     */
    public $LCCParameters;
    /**
     * The ProfileRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgProfileRef
     */
    public $ProfileRef;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmail[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddress[]
     */
    public $Address;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDocument[]
     */
    public $Document;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerRefNumber
     */
    public $TravelerRefNumber;
    /**
     * The FlightSegmentRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString3
     */
    public $FlightSegmentRPHs;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthDate;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AccompaniedByInfant
     * @var bool
     */
    public $AccompaniedByInfant;
    /**
     * Constructor method for AirTravelerType
     * @uses DgAirTravelerType::setNumberOfBaggages()
     * @uses DgAirTravelerType::setNumberOfBaggages1()
     * @uses DgAirTravelerType::setHandLuggages()
     * @uses DgAirTravelerType::setHandLuggages1()
     * @uses DgAirTravelerType::setLCCParameters()
     * @uses DgAirTravelerType::setProfileRef()
     * @uses DgAirTravelerType::setPersonName()
     * @uses DgAirTravelerType::setTelephone()
     * @uses DgAirTravelerType::setEmail()
     * @uses DgAirTravelerType::setAddress()
     * @uses DgAirTravelerType::setCustLoyalty()
     * @uses DgAirTravelerType::setDocument()
     * @uses DgAirTravelerType::setPassengerTypeQuantity()
     * @uses DgAirTravelerType::setTravelerRefNumber()
     * @uses DgAirTravelerType::setFlightSegmentRPHs()
     * @uses DgAirTravelerType::setBirthDate()
     * @uses DgAirTravelerType::setGender()
     * @uses DgAirTravelerType::setShareSynchInd()
     * @uses DgAirTravelerType::setShareMarketInd()
     * @uses DgAirTravelerType::setCurrencyCode()
     * @uses DgAirTravelerType::setPassengerTypeCode()
     * @uses DgAirTravelerType::setAccompaniedByInfant()
     * @param int $numberOfBaggages
     * @param int $numberOfBaggages1
     * @param int $handLuggages
     * @param int $handLuggages1
     * @param \dgsoft\StructType\DgLCCParameters $lCCParameters
     * @param \dgsoft\StructType\DgProfileRef $profileRef
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @param \dgsoft\StructType\DgEmail[] $email
     * @param \dgsoft\StructType\DgAddress[] $address
     * @param \dgsoft\StructType\DgCustLoyalty[] $custLoyalty
     * @param \dgsoft\StructType\DgDocument[] $document
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity
     * @param \dgsoft\StructType\DgTravelerRefNumber $travelerRefNumber
     * @param \dgsoft\ArrayType\DgArrayOfString3 $flightSegmentRPHs
     * @param string $birthDate
     * @param string $gender
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $currencyCode
     * @param string $passengerTypeCode
     * @param bool $accompaniedByInfant
     */
    public function __construct($numberOfBaggages = null, $numberOfBaggages1 = null, $handLuggages = null, $handLuggages1 = null, \dgsoft\StructType\DgLCCParameters $lCCParameters = null, \dgsoft\StructType\DgProfileRef $profileRef = null, \dgsoft\StructType\DgPersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $custLoyalty = array(), array $document = array(), \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity = null, \dgsoft\StructType\DgTravelerRefNumber $travelerRefNumber = null, \dgsoft\ArrayType\DgArrayOfString3 $flightSegmentRPHs = null, $birthDate = null, $gender = null, $shareSynchInd = null, $shareMarketInd = null, $currencyCode = null, $passengerTypeCode = null, $accompaniedByInfant = null)
    {
        $this
            ->setNumberOfBaggages($numberOfBaggages)
            ->setNumberOfBaggages1($numberOfBaggages1)
            ->setHandLuggages($handLuggages)
            ->setHandLuggages1($handLuggages1)
            ->setLCCParameters($lCCParameters)
            ->setProfileRef($profileRef)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setCustLoyalty($custLoyalty)
            ->setDocument($document)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setFlightSegmentRPHs($flightSegmentRPHs)
            ->setBirthDate($birthDate)
            ->setGender($gender)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCurrencyCode($currencyCode)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAccompaniedByInfant($accompaniedByInfant);
    }
    /**
     * Get NumberOfBaggages value
     * @return int
     */
    public function getNumberOfBaggages()
    {
        return $this->NumberOfBaggages;
    }
    /**
     * Set NumberOfBaggages value
     * @param int $numberOfBaggages
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setNumberOfBaggages($numberOfBaggages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBaggages) && !is_numeric($numberOfBaggages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBaggages)), __LINE__);
        }
        $this->NumberOfBaggages = $numberOfBaggages;
        return $this;
    }
    /**
     * Get NumberOfBaggages1 value
     * @return int
     */
    public function getNumberOfBaggages1()
    {
        return $this->NumberOfBaggages1;
    }
    /**
     * Set NumberOfBaggages1 value
     * @param int $numberOfBaggages1
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setNumberOfBaggages1($numberOfBaggages1 = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBaggages1) && !is_numeric($numberOfBaggages1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBaggages1)), __LINE__);
        }
        $this->NumberOfBaggages1 = $numberOfBaggages1;
        return $this;
    }
    /**
     * Get HandLuggages value
     * @return int
     */
    public function getHandLuggages()
    {
        return $this->HandLuggages;
    }
    /**
     * Set HandLuggages value
     * @param int $handLuggages
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setHandLuggages($handLuggages = null)
    {
        // validation for constraint: int
        if (!is_null($handLuggages) && !is_numeric($handLuggages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($handLuggages)), __LINE__);
        }
        $this->HandLuggages = $handLuggages;
        return $this;
    }
    /**
     * Get HandLuggages1 value
     * @return int
     */
    public function getHandLuggages1()
    {
        return $this->HandLuggages1;
    }
    /**
     * Set HandLuggages1 value
     * @param int $handLuggages1
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setHandLuggages1($handLuggages1 = null)
    {
        // validation for constraint: int
        if (!is_null($handLuggages1) && !is_numeric($handLuggages1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($handLuggages1)), __LINE__);
        }
        $this->HandLuggages1 = $handLuggages1;
        return $this;
    }
    /**
     * Get LCCParameters value
     * @return \dgsoft\StructType\DgLCCParameters|null
     */
    public function getLCCParameters()
    {
        return $this->LCCParameters;
    }
    /**
     * Set LCCParameters value
     * @param \dgsoft\StructType\DgLCCParameters $lCCParameters
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setLCCParameters(\dgsoft\StructType\DgLCCParameters $lCCParameters = null)
    {
        $this->LCCParameters = $lCCParameters;
        return $this;
    }
    /**
     * Get ProfileRef value
     * @return \dgsoft\StructType\DgProfileRef|null
     */
    public function getProfileRef()
    {
        return $this->ProfileRef;
    }
    /**
     * Set ProfileRef value
     * @param \dgsoft\StructType\DgProfileRef $profileRef
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setProfileRef(\dgsoft\StructType\DgProfileRef $profileRef = null)
    {
        $this->ProfileRef = $profileRef;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone[] $telephone
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $airTravelerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeTelephoneItem instanceof \dgsoft\StructType\DgTelephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($airTravelerTypeTelephoneItem) ? get_class($airTravelerTypeTelephoneItem) : gettype($airTravelerTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTelephone $item
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function addToTelephone(\dgsoft\StructType\DgTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \dgsoft\StructType\DgTelephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \dgsoft\StructType\DgEmail[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmail[] $email
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $airTravelerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeEmailItem instanceof \dgsoft\StructType\DgEmail) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmail, "%s" given', is_object($airTravelerTypeEmailItem) ? get_class($airTravelerTypeEmailItem) : gettype($airTravelerTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmail $item
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function addToEmail(\dgsoft\StructType\DgEmail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmail) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \dgsoft\StructType\DgEmail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddress[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddress[] $address
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $airTravelerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeAddressItem instanceof \dgsoft\StructType\DgAddress) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddress, "%s" given', is_object($airTravelerTypeAddressItem) ? get_class($airTravelerTypeAddressItem) : gettype($airTravelerTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddress $item
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function addToAddress(\dgsoft\StructType\DgAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddress) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \dgsoft\StructType\DgAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \dgsoft\StructType\DgCustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustLoyalty[] $custLoyalty
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        foreach ($custLoyalty as $airTravelerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeCustLoyaltyItem instanceof \dgsoft\StructType\DgCustLoyalty) {
                throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgCustLoyalty, "%s" given', is_object($airTravelerTypeCustLoyaltyItem) ? get_class($airTravelerTypeCustLoyaltyItem) : gettype($airTravelerTypeCustLoyaltyItem)), __LINE__);
            }
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustLoyalty $item
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function addToCustLoyalty(\dgsoft\StructType\DgCustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgCustLoyalty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \dgsoft\StructType\DgDocument[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocument[] $document
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $airTravelerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$airTravelerTypeDocumentItem instanceof \dgsoft\StructType\DgDocument) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocument, "%s" given', is_object($airTravelerTypeDocumentItem) ? get_class($airTravelerTypeDocumentItem) : gettype($airTravelerTypeDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDocument $item
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function addToDocument(\dgsoft\StructType\DgDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDocument) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \dgsoft\StructType\DgDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setPassengerTypeQuantity(\dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \dgsoft\StructType\DgTravelerRefNumber|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param \dgsoft\StructType\DgTravelerRefNumber $travelerRefNumber
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setTravelerRefNumber(\dgsoft\StructType\DgTravelerRefNumber $travelerRefNumber = null)
    {
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get FlightSegmentRPHs value
     * @return \dgsoft\ArrayType\DgArrayOfString3|null
     */
    public function getFlightSegmentRPHs()
    {
        return $this->FlightSegmentRPHs;
    }
    /**
     * Set FlightSegmentRPHs value
     * @param \dgsoft\ArrayType\DgArrayOfString3 $flightSegmentRPHs
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setFlightSegmentRPHs(\dgsoft\ArrayType\DgArrayOfString3 $flightSegmentRPHs = null)
    {
        $this->FlightSegmentRPHs = $flightSegmentRPHs;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AccompaniedByInfant value
     * @return bool|null
     */
    public function getAccompaniedByInfant()
    {
        return $this->AccompaniedByInfant;
    }
    /**
     * Set AccompaniedByInfant value
     * @param bool $accompaniedByInfant
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public function setAccompaniedByInfant($accompaniedByInfant = null)
    {
        // validation for constraint: boolean
        if (!is_null($accompaniedByInfant) && !is_bool($accompaniedByInfant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accompaniedByInfant)), __LINE__);
        }
        $this->AccompaniedByInfant = $accompaniedByInfant;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
