<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReadRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirReadRequest extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $Airline;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $DepartureAirport;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $Name;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephone
     */
    public $Telephone;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustLoyalty
     */
    public $CustLoyalty;
    /**
     * The CreditCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentCardType
     */
    public $CreditCardInfo;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketingInfoRS_Type
     */
    public $TicketNumber;
    /**
     * The QueueInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueueInfo
     */
    public $QueueInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The SeatNumber
     * @var string
     */
    public $SeatNumber;
    /**
     * The IncludeFF_EquivPartnerLev
     * @var bool
     */
    public $IncludeFF_EquivPartnerLev;
    /**
     * The ReturnFF_Number
     * @var bool
     */
    public $ReturnFF_Number;
    /**
     * The ReturnDownlineSeg
     * @var bool
     */
    public $ReturnDownlineSeg;
    /**
     * The InfoToReturn
     * @var string
     */
    public $InfoToReturn;
    /**
     * The FF_RequestCriteria
     * @var string
     */
    public $FF_RequestCriteria;
    /**
     * Constructor method for AirReadRequest
     * @uses DgAirReadRequest::setPOS()
     * @uses DgAirReadRequest::setAirline()
     * @uses DgAirReadRequest::setFlightNumber()
     * @uses DgAirReadRequest::setDepartureAirport()
     * @uses DgAirReadRequest::setDepartureDate()
     * @uses DgAirReadRequest::setName()
     * @uses DgAirReadRequest::setTelephone()
     * @uses DgAirReadRequest::setCustLoyalty()
     * @uses DgAirReadRequest::setCreditCardInfo()
     * @uses DgAirReadRequest::setTicketNumber()
     * @uses DgAirReadRequest::setQueueInfo()
     * @uses DgAirReadRequest::setTPA_Extensions()
     * @uses DgAirReadRequest::setSeatNumber()
     * @uses DgAirReadRequest::setIncludeFF_EquivPartnerLev()
     * @uses DgAirReadRequest::setReturnFF_Number()
     * @uses DgAirReadRequest::setReturnDownlineSeg()
     * @uses DgAirReadRequest::setInfoToReturn()
     * @uses DgAirReadRequest::setFF_RequestCriteria()
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgCompanyNameType $airline
     * @param string $flightNumber
     * @param \dgsoft\StructType\DgLocationType $departureAirport
     * @param string $departureDate
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @param \dgsoft\StructType\DgTelephone $telephone
     * @param \dgsoft\StructType\DgCustLoyalty $custLoyalty
     * @param \dgsoft\StructType\DgPaymentCardType $creditCardInfo
     * @param \dgsoft\StructType\DgTicketingInfoRS_Type $ticketNumber
     * @param \dgsoft\StructType\DgQueueInfo $queueInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $seatNumber
     * @param bool $includeFF_EquivPartnerLev
     * @param bool $returnFF_Number
     * @param bool $returnDownlineSeg
     * @param string $infoToReturn
     * @param string $fF_RequestCriteria
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgCompanyNameType $airline = null, $flightNumber = null, \dgsoft\StructType\DgLocationType $departureAirport = null, $departureDate = null, \dgsoft\StructType\DgPersonNameType $name = null, \dgsoft\StructType\DgTelephone $telephone = null, \dgsoft\StructType\DgCustLoyalty $custLoyalty = null, \dgsoft\StructType\DgPaymentCardType $creditCardInfo = null, \dgsoft\StructType\DgTicketingInfoRS_Type $ticketNumber = null, \dgsoft\StructType\DgQueueInfo $queueInfo = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $seatNumber = null, $includeFF_EquivPartnerLev = null, $returnFF_Number = null, $returnDownlineSeg = null, $infoToReturn = null, $fF_RequestCriteria = null)
    {
        $this
            ->setPOS($pOS)
            ->setAirline($airline)
            ->setFlightNumber($flightNumber)
            ->setDepartureAirport($departureAirport)
            ->setDepartureDate($departureDate)
            ->setName($name)
            ->setTelephone($telephone)
            ->setCustLoyalty($custLoyalty)
            ->setCreditCardInfo($creditCardInfo)
            ->setTicketNumber($ticketNumber)
            ->setQueueInfo($queueInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSeatNumber($seatNumber)
            ->setIncludeFF_EquivPartnerLev($includeFF_EquivPartnerLev)
            ->setReturnFF_Number($returnFF_Number)
            ->setReturnDownlineSeg($returnDownlineSeg)
            ->setInfoToReturn($infoToReturn)
            ->setFF_RequestCriteria($fF_RequestCriteria);
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Airline value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \dgsoft\StructType\DgCompanyNameType $airline
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setAirline(\dgsoft\StructType\DgCompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \dgsoft\StructType\DgLocationType $departureAirport
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setDepartureAirport(\dgsoft\StructType\DgLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Name value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setName(\dgsoft\StructType\DgPersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgTelephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \dgsoft\StructType\DgTelephone $telephone
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setTelephone(\dgsoft\StructType\DgTelephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \dgsoft\StructType\DgCustLoyalty|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @param \dgsoft\StructType\DgCustLoyalty $custLoyalty
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setCustLoyalty(\dgsoft\StructType\DgCustLoyalty $custLoyalty = null)
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Get CreditCardInfo value
     * @return \dgsoft\StructType\DgPaymentCardType|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \dgsoft\StructType\DgPaymentCardType $creditCardInfo
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setCreditCardInfo(\dgsoft\StructType\DgPaymentCardType $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return \dgsoft\StructType\DgTicketingInfoRS_Type|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param \dgsoft\StructType\DgTicketingInfoRS_Type $ticketNumber
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setTicketNumber(\dgsoft\StructType\DgTicketingInfoRS_Type $ticketNumber = null)
    {
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \dgsoft\StructType\DgQueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \dgsoft\StructType\DgQueueInfo $queueInfo
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setQueueInfo(\dgsoft\StructType\DgQueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get IncludeFF_EquivPartnerLev value
     * @return bool|null
     */
    public function getIncludeFF_EquivPartnerLev()
    {
        return $this->IncludeFF_EquivPartnerLev;
    }
    /**
     * Set IncludeFF_EquivPartnerLev value
     * @param bool $includeFF_EquivPartnerLev
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setIncludeFF_EquivPartnerLev($includeFF_EquivPartnerLev = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFF_EquivPartnerLev) && !is_bool($includeFF_EquivPartnerLev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeFF_EquivPartnerLev)), __LINE__);
        }
        $this->IncludeFF_EquivPartnerLev = $includeFF_EquivPartnerLev;
        return $this;
    }
    /**
     * Get ReturnFF_Number value
     * @return bool|null
     */
    public function getReturnFF_Number()
    {
        return $this->ReturnFF_Number;
    }
    /**
     * Set ReturnFF_Number value
     * @param bool $returnFF_Number
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setReturnFF_Number($returnFF_Number = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnFF_Number) && !is_bool($returnFF_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnFF_Number)), __LINE__);
        }
        $this->ReturnFF_Number = $returnFF_Number;
        return $this;
    }
    /**
     * Get ReturnDownlineSeg value
     * @return bool|null
     */
    public function getReturnDownlineSeg()
    {
        return $this->ReturnDownlineSeg;
    }
    /**
     * Set ReturnDownlineSeg value
     * @param bool $returnDownlineSeg
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setReturnDownlineSeg($returnDownlineSeg = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnDownlineSeg) && !is_bool($returnDownlineSeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnDownlineSeg)), __LINE__);
        }
        $this->ReturnDownlineSeg = $returnDownlineSeg;
        return $this;
    }
    /**
     * Get InfoToReturn value
     * @return string|null
     */
    public function getInfoToReturn()
    {
        return $this->InfoToReturn;
    }
    /**
     * Set InfoToReturn value
     * @param string $infoToReturn
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setInfoToReturn($infoToReturn = null)
    {
        // validation for constraint: string
        if (!is_null($infoToReturn) && !is_string($infoToReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoToReturn)), __LINE__);
        }
        $this->InfoToReturn = $infoToReturn;
        return $this;
    }
    /**
     * Get FF_RequestCriteria value
     * @return string|null
     */
    public function getFF_RequestCriteria()
    {
        return $this->FF_RequestCriteria;
    }
    /**
     * Set FF_RequestCriteria value
     * @param string $fF_RequestCriteria
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public function setFF_RequestCriteria($fF_RequestCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($fF_RequestCriteria) && !is_string($fF_RequestCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fF_RequestCriteria)), __LINE__);
        }
        $this->FF_RequestCriteria = $fF_RequestCriteria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
