<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirItineraryType extends AbstractStructBase
{
    /**
     * The OriginDestinationOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAirItineraryTypeOriginDestinationOption
     */
    public $OriginDestinationOptions;
    /**
     * The OriginDestinationCombinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOriginDestinationCombinationType
     */
    public $OriginDestinationCombinations;
    /**
     * The ValidatingAirlineCode
     * @var string
     */
    public $ValidatingAirlineCode;
    /**
     * The DirectionInd
     * @var string
     */
    public $DirectionInd;
    /**
     * The CalculateSF
     * @var bool
     */
    public $CalculateSF;
    /**
     * Constructor method for AirItineraryType
     * @uses DgAirItineraryType::setOriginDestinationOptions()
     * @uses DgAirItineraryType::setOriginDestinationCombinations()
     * @uses DgAirItineraryType::setValidatingAirlineCode()
     * @uses DgAirItineraryType::setDirectionInd()
     * @uses DgAirItineraryType::setCalculateSF()
     * @param \dgsoft\ArrayType\DgArrayOfAirItineraryTypeOriginDestinationOption $originDestinationOptions
     * @param \dgsoft\ArrayType\DgArrayOfOriginDestinationCombinationType $originDestinationCombinations
     * @param string $validatingAirlineCode
     * @param string $directionInd
     * @param bool $calculateSF
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfAirItineraryTypeOriginDestinationOption $originDestinationOptions = null, \dgsoft\ArrayType\DgArrayOfOriginDestinationCombinationType $originDestinationCombinations = null, $validatingAirlineCode = null, $directionInd = null, $calculateSF = null)
    {
        $this
            ->setOriginDestinationOptions($originDestinationOptions)
            ->setOriginDestinationCombinations($originDestinationCombinations)
            ->setValidatingAirlineCode($validatingAirlineCode)
            ->setDirectionInd($directionInd)
            ->setCalculateSF($calculateSF);
    }
    /**
     * Get OriginDestinationOptions value
     * @return \dgsoft\ArrayType\DgArrayOfAirItineraryTypeOriginDestinationOption|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \dgsoft\ArrayType\DgArrayOfAirItineraryTypeOriginDestinationOption $originDestinationOptions
     * @return \dgsoft\StructType\DgAirItineraryType
     */
    public function setOriginDestinationOptions(\dgsoft\ArrayType\DgArrayOfAirItineraryTypeOriginDestinationOption $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Get OriginDestinationCombinations value
     * @return \dgsoft\ArrayType\DgArrayOfOriginDestinationCombinationType|null
     */
    public function getOriginDestinationCombinations()
    {
        return $this->OriginDestinationCombinations;
    }
    /**
     * Set OriginDestinationCombinations value
     * @param \dgsoft\ArrayType\DgArrayOfOriginDestinationCombinationType $originDestinationCombinations
     * @return \dgsoft\StructType\DgAirItineraryType
     */
    public function setOriginDestinationCombinations(\dgsoft\ArrayType\DgArrayOfOriginDestinationCombinationType $originDestinationCombinations = null)
    {
        $this->OriginDestinationCombinations = $originDestinationCombinations;
        return $this;
    }
    /**
     * Get ValidatingAirlineCode value
     * @return string|null
     */
    public function getValidatingAirlineCode()
    {
        return $this->ValidatingAirlineCode;
    }
    /**
     * Set ValidatingAirlineCode value
     * @param string $validatingAirlineCode
     * @return \dgsoft\StructType\DgAirItineraryType
     */
    public function setValidatingAirlineCode($validatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineCode) && !is_string($validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validatingAirlineCode)), __LINE__);
        }
        $this->ValidatingAirlineCode = $validatingAirlineCode;
        return $this;
    }
    /**
     * Get DirectionInd value
     * @return string|null
     */
    public function getDirectionInd()
    {
        return $this->DirectionInd;
    }
    /**
     * Set DirectionInd value
     * @uses \dgsoft\EnumType\DgAirTripType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionInd
     * @return \dgsoft\StructType\DgAirItineraryType
     */
    public function setDirectionInd($directionInd = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAirTripType::valueIsValid($directionInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $directionInd, implode(', ', \dgsoft\EnumType\DgAirTripType::getValidValues())), __LINE__);
        }
        $this->DirectionInd = $directionInd;
        return $this;
    }
    /**
     * Get CalculateSF value
     * @return bool|null
     */
    public function getCalculateSF()
    {
        return $this->CalculateSF;
    }
    /**
     * Set CalculateSF value
     * @param bool $calculateSF
     * @return \dgsoft\StructType\DgAirItineraryType
     */
    public function setCalculateSF($calculateSF = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateSF) && !is_bool($calculateSF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($calculateSF)), __LINE__);
        }
        $this->CalculateSF = $calculateSF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
