<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAirItineraryPricingInfoType extends AbstractStructBase
{
    /**
     * The ItinTotalFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareType
     */
    public $ItinTotalFare;
    /**
     * The MinCCOBFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MinCCOBFee;
    /**
     * The MaxCCOBFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaxCCOBFee;
    /**
     * The CCOBFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CCOBFee;
    /**
     * The PTC_FareBreakdowns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownType
     */
    public $PTC_FareBreakdowns;
    /**
     * The FareInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAirItineraryPricingInfoTypeFareInfo
     */
    public $FareInfos;
    /**
     * The ServiceFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgServiceFeesType
     */
    public $ServiceFees;
    /**
     * The ITIndex
     * @var int
     */
    public $ITIndex;
    /**
     * The PricingSource
     * @var string
     */
    public $PricingSource;
    /**
     * Constructor method for AirItineraryPricingInfoType
     * @uses DgAirItineraryPricingInfoType::setItinTotalFare()
     * @uses DgAirItineraryPricingInfoType::setMinCCOBFee()
     * @uses DgAirItineraryPricingInfoType::setMaxCCOBFee()
     * @uses DgAirItineraryPricingInfoType::setCCOBFee()
     * @uses DgAirItineraryPricingInfoType::setPTC_FareBreakdowns()
     * @uses DgAirItineraryPricingInfoType::setFareInfos()
     * @uses DgAirItineraryPricingInfoType::setServiceFees()
     * @uses DgAirItineraryPricingInfoType::setITIndex()
     * @uses DgAirItineraryPricingInfoType::setPricingSource()
     * @param \dgsoft\StructType\DgFareType $itinTotalFare
     * @param float $minCCOBFee
     * @param float $maxCCOBFee
     * @param float $cCOBFee
     * @param \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownType $pTC_FareBreakdowns
     * @param \dgsoft\ArrayType\DgArrayOfAirItineraryPricingInfoTypeFareInfo $fareInfos
     * @param \dgsoft\StructType\DgServiceFeesType $serviceFees
     * @param int $iTIndex
     * @param string $pricingSource
     */
    public function __construct(\dgsoft\StructType\DgFareType $itinTotalFare = null, $minCCOBFee = null, $maxCCOBFee = null, $cCOBFee = null, \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownType $pTC_FareBreakdowns = null, \dgsoft\ArrayType\DgArrayOfAirItineraryPricingInfoTypeFareInfo $fareInfos = null, \dgsoft\StructType\DgServiceFeesType $serviceFees = null, $iTIndex = null, $pricingSource = null)
    {
        $this
            ->setItinTotalFare($itinTotalFare)
            ->setMinCCOBFee($minCCOBFee)
            ->setMaxCCOBFee($maxCCOBFee)
            ->setCCOBFee($cCOBFee)
            ->setPTC_FareBreakdowns($pTC_FareBreakdowns)
            ->setFareInfos($fareInfos)
            ->setServiceFees($serviceFees)
            ->setITIndex($iTIndex)
            ->setPricingSource($pricingSource);
    }
    /**
     * Get ItinTotalFare value
     * @return \dgsoft\StructType\DgFareType|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @param \dgsoft\StructType\DgFareType $itinTotalFare
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setItinTotalFare(\dgsoft\StructType\DgFareType $itinTotalFare = null)
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Get MinCCOBFee value
     * @return float|null
     */
    public function getMinCCOBFee()
    {
        return $this->MinCCOBFee;
    }
    /**
     * Set MinCCOBFee value
     * @param float $minCCOBFee
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setMinCCOBFee($minCCOBFee = null)
    {
        $this->MinCCOBFee = $minCCOBFee;
        return $this;
    }
    /**
     * Get MaxCCOBFee value
     * @return float|null
     */
    public function getMaxCCOBFee()
    {
        return $this->MaxCCOBFee;
    }
    /**
     * Set MaxCCOBFee value
     * @param float $maxCCOBFee
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setMaxCCOBFee($maxCCOBFee = null)
    {
        $this->MaxCCOBFee = $maxCCOBFee;
        return $this;
    }
    /**
     * Get CCOBFee value
     * @return float|null
     */
    public function getCCOBFee()
    {
        return $this->CCOBFee;
    }
    /**
     * Set CCOBFee value
     * @param float $cCOBFee
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setCCOBFee($cCOBFee = null)
    {
        $this->CCOBFee = $cCOBFee;
        return $this;
    }
    /**
     * Get PTC_FareBreakdowns value
     * @return \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownType|null
     */
    public function getPTC_FareBreakdowns()
    {
        return $this->PTC_FareBreakdowns;
    }
    /**
     * Set PTC_FareBreakdowns value
     * @param \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownType $pTC_FareBreakdowns
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setPTC_FareBreakdowns(\dgsoft\ArrayType\DgArrayOfPTCFareBreakdownType $pTC_FareBreakdowns = null)
    {
        $this->PTC_FareBreakdowns = $pTC_FareBreakdowns;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \dgsoft\ArrayType\DgArrayOfAirItineraryPricingInfoTypeFareInfo|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \dgsoft\ArrayType\DgArrayOfAirItineraryPricingInfoTypeFareInfo $fareInfos
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setFareInfos(\dgsoft\ArrayType\DgArrayOfAirItineraryPricingInfoTypeFareInfo $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get ServiceFees value
     * @return \dgsoft\StructType\DgServiceFeesType|null
     */
    public function getServiceFees()
    {
        return $this->ServiceFees;
    }
    /**
     * Set ServiceFees value
     * @param \dgsoft\StructType\DgServiceFeesType $serviceFees
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setServiceFees(\dgsoft\StructType\DgServiceFeesType $serviceFees = null)
    {
        $this->ServiceFees = $serviceFees;
        return $this;
    }
    /**
     * Get ITIndex value
     * @return int|null
     */
    public function getITIndex()
    {
        return $this->ITIndex;
    }
    /**
     * Set ITIndex value
     * @param int $iTIndex
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setITIndex($iTIndex = null)
    {
        // validation for constraint: int
        if (!is_null($iTIndex) && !is_numeric($iTIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iTIndex)), __LINE__);
        }
        $this->ITIndex = $iTIndex;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \dgsoft\EnumType\DgPricingSourceType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPricingSourceType::valueIsValid($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pricingSource, implode(', ', \dgsoft\EnumType\DgPricingSourceType::getValidValues())), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
