<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgreementsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAgreementsType extends AbstractStructBase
{
    /**
     * The Certification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCertificationType[]
     */
    public $Certification;
    /**
     * The AllianceConsortium
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAllianceConsortiumType[]
     */
    public $AllianceConsortium;
    /**
     * The CommissionInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCommissionInfoType[]
     */
    public $CommissionInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AgreementsType
     * @uses DgAgreementsType::setCertification()
     * @uses DgAgreementsType::setAllianceConsortium()
     * @uses DgAgreementsType::setCommissionInfo()
     * @uses DgAgreementsType::setTPA_Extensions()
     * @uses DgAgreementsType::setShareSynchInd()
     * @uses DgAgreementsType::setShareMarketInd()
     * @param \dgsoft\StructType\DgCertificationType[] $certification
     * @param \dgsoft\StructType\DgAllianceConsortiumType[] $allianceConsortium
     * @param \dgsoft\StructType\DgCommissionInfoType[] $commissionInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $certification = array(), array $allianceConsortium = array(), array $commissionInfo = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setCertification($certification)
            ->setAllianceConsortium($allianceConsortium)
            ->setCommissionInfo($commissionInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Certification value
     * @return \dgsoft\StructType\DgCertificationType[]|null
     */
    public function getCertification()
    {
        return $this->Certification;
    }
    /**
     * Set Certification value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCertificationType[] $certification
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function setCertification(array $certification = array())
    {
        foreach ($certification as $agreementsTypeCertificationItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeCertificationItem instanceof \dgsoft\StructType\DgCertificationType) {
                throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of \dgsoft\StructType\DgCertificationType, "%s" given', is_object($agreementsTypeCertificationItem) ? get_class($agreementsTypeCertificationItem) : gettype($agreementsTypeCertificationItem)), __LINE__);
            }
        }
        $this->Certification = $certification;
        return $this;
    }
    /**
     * Add item to Certification value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCertificationType $item
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function addToCertification(\dgsoft\StructType\DgCertificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCertificationType) {
            throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of \dgsoft\StructType\DgCertificationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Certification[] = $item;
        return $this;
    }
    /**
     * Get AllianceConsortium value
     * @return \dgsoft\StructType\DgAllianceConsortiumType[]|null
     */
    public function getAllianceConsortium()
    {
        return $this->AllianceConsortium;
    }
    /**
     * Set AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAllianceConsortiumType[] $allianceConsortium
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function setAllianceConsortium(array $allianceConsortium = array())
    {
        foreach ($allianceConsortium as $agreementsTypeAllianceConsortiumItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeAllianceConsortiumItem instanceof \dgsoft\StructType\DgAllianceConsortiumType) {
                throw new \InvalidArgumentException(sprintf('The AllianceConsortium property can only contain items of \dgsoft\StructType\DgAllianceConsortiumType, "%s" given', is_object($agreementsTypeAllianceConsortiumItem) ? get_class($agreementsTypeAllianceConsortiumItem) : gettype($agreementsTypeAllianceConsortiumItem)), __LINE__);
            }
        }
        $this->AllianceConsortium = $allianceConsortium;
        return $this;
    }
    /**
     * Add item to AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAllianceConsortiumType $item
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function addToAllianceConsortium(\dgsoft\StructType\DgAllianceConsortiumType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAllianceConsortiumType) {
            throw new \InvalidArgumentException(sprintf('The AllianceConsortium property can only contain items of \dgsoft\StructType\DgAllianceConsortiumType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AllianceConsortium[] = $item;
        return $this;
    }
    /**
     * Get CommissionInfo value
     * @return \dgsoft\StructType\DgCommissionInfoType[]|null
     */
    public function getCommissionInfo()
    {
        return $this->CommissionInfo;
    }
    /**
     * Set CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommissionInfoType[] $commissionInfo
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function setCommissionInfo(array $commissionInfo = array())
    {
        foreach ($commissionInfo as $agreementsTypeCommissionInfoItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeCommissionInfoItem instanceof \dgsoft\StructType\DgCommissionInfoType) {
                throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of \dgsoft\StructType\DgCommissionInfoType, "%s" given', is_object($agreementsTypeCommissionInfoItem) ? get_class($agreementsTypeCommissionInfoItem) : gettype($agreementsTypeCommissionInfoItem)), __LINE__);
            }
        }
        $this->CommissionInfo = $commissionInfo;
        return $this;
    }
    /**
     * Add item to CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommissionInfoType $item
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function addToCommissionInfo(\dgsoft\StructType\DgCommissionInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCommissionInfoType) {
            throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of \dgsoft\StructType\DgCommissionInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommissionInfo[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAgreementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
