<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvResTicketing StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdvResTicketing extends DgAdvResTicketingType
{
    /**
     * The FirstTicketDate
     * @var string
     */
    public $FirstTicketDate;
    /**
     * The LastTicketDate
     * @var string
     */
    public $LastTicketDate;
    /**
     * Constructor method for AdvResTicketing
     * @uses DgAdvResTicketing::setFirstTicketDate()
     * @uses DgAdvResTicketing::setLastTicketDate()
     * @param string $firstTicketDate
     * @param string $lastTicketDate
     */
    public function __construct($firstTicketDate = null, $lastTicketDate = null)
    {
        $this
            ->setFirstTicketDate($firstTicketDate)
            ->setLastTicketDate($lastTicketDate);
    }
    /**
     * Get FirstTicketDate value
     * @return string|null
     */
    public function getFirstTicketDate()
    {
        return $this->FirstTicketDate;
    }
    /**
     * Set FirstTicketDate value
     * @param string $firstTicketDate
     * @return \dgsoft\StructType\DgAdvResTicketing
     */
    public function setFirstTicketDate($firstTicketDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstTicketDate) && !is_string($firstTicketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstTicketDate)), __LINE__);
        }
        $this->FirstTicketDate = $firstTicketDate;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \dgsoft\StructType\DgAdvResTicketing
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastTicketDate) && !is_string($lastTicketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastTicketDate)), __LINE__);
        }
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdvResTicketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
