<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAddressType extends AbstractStructBase
{
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location;
    /**
     * The AreaLocationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaLocationCode;
    /**
     * The TaxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNumber;
    /**
     * The TaxOffice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOffice;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The StreetNmbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgStreetNmbr
     */
    public $StreetNmbr;
    /**
     * The BldgRoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBldgRoom[]
     */
    public $BldgRoom;
    /**
     * The AddressLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The County
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The StateProv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgStateProvType
     */
    public $StateProv;
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCountryNameType
     */
    public $CountryName;
    /**
     * The FormattedInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $FormattedInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for AddressType
     * @uses DgAddressType::setContactName()
     * @uses DgAddressType::setLocation()
     * @uses DgAddressType::setAreaLocationCode()
     * @uses DgAddressType::setTaxNumber()
     * @uses DgAddressType::setTaxOffice()
     * @uses DgAddressType::setCompany()
     * @uses DgAddressType::setStreetNmbr()
     * @uses DgAddressType::setBldgRoom()
     * @uses DgAddressType::setAddressLine()
     * @uses DgAddressType::setCityName()
     * @uses DgAddressType::setPostalCode()
     * @uses DgAddressType::setCounty()
     * @uses DgAddressType::setStateProv()
     * @uses DgAddressType::setCountryName()
     * @uses DgAddressType::setFormattedInd()
     * @uses DgAddressType::setShareSynchInd()
     * @uses DgAddressType::setShareMarketInd()
     * @uses DgAddressType::setType()
     * @param string $contactName
     * @param string $location
     * @param string $areaLocationCode
     * @param string $taxNumber
     * @param string $taxOffice
     * @param string $company
     * @param \dgsoft\StructType\DgStreetNmbr $streetNmbr
     * @param \dgsoft\StructType\DgBldgRoom[] $bldgRoom
     * @param string[] $addressLine
     * @param string $cityName
     * @param string $postalCode
     * @param string $county
     * @param \dgsoft\StructType\DgStateProvType $stateProv
     * @param \dgsoft\StructType\DgCountryNameType $countryName
     * @param bool $formattedInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $type
     */
    public function __construct($contactName = null, $location = null, $areaLocationCode = null, $taxNumber = null, $taxOffice = null, $company = null, \dgsoft\StructType\DgStreetNmbr $streetNmbr = null, array $bldgRoom = array(), array $addressLine = array(), $cityName = null, $postalCode = null, $county = null, \dgsoft\StructType\DgStateProvType $stateProv = null, \dgsoft\StructType\DgCountryNameType $countryName = null, $formattedInd = false, $shareSynchInd = null, $shareMarketInd = null, $type = null)
    {
        $this
            ->setContactName($contactName)
            ->setLocation($location)
            ->setAreaLocationCode($areaLocationCode)
            ->setTaxNumber($taxNumber)
            ->setTaxOffice($taxOffice)
            ->setCompany($company)
            ->setStreetNmbr($streetNmbr)
            ->setBldgRoom($bldgRoom)
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setPostalCode($postalCode)
            ->setCounty($county)
            ->setStateProv($stateProv)
            ->setCountryName($countryName)
            ->setFormattedInd($formattedInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setType($type);
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get AreaLocationCode value
     * @return string|null
     */
    public function getAreaLocationCode()
    {
        return $this->AreaLocationCode;
    }
    /**
     * Set AreaLocationCode value
     * @param string $areaLocationCode
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setAreaLocationCode($areaLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaLocationCode) && !is_string($areaLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaLocationCode)), __LINE__);
        }
        $this->AreaLocationCode = $areaLocationCode;
        return $this;
    }
    /**
     * Get TaxNumber value
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->TaxNumber;
    }
    /**
     * Set TaxNumber value
     * @param string $taxNumber
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxNumber)), __LINE__);
        }
        $this->TaxNumber = $taxNumber;
        return $this;
    }
    /**
     * Get TaxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->TaxOffice;
    }
    /**
     * Set TaxOffice value
     * @param string $taxOffice
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxOffice)), __LINE__);
        }
        $this->TaxOffice = $taxOffice;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get StreetNmbr value
     * @return \dgsoft\StructType\DgStreetNmbr|null
     */
    public function getStreetNmbr()
    {
        return $this->StreetNmbr;
    }
    /**
     * Set StreetNmbr value
     * @param \dgsoft\StructType\DgStreetNmbr $streetNmbr
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setStreetNmbr(\dgsoft\StructType\DgStreetNmbr $streetNmbr = null)
    {
        $this->StreetNmbr = $streetNmbr;
        return $this;
    }
    /**
     * Get BldgRoom value
     * @return \dgsoft\StructType\DgBldgRoom[]|null
     */
    public function getBldgRoom()
    {
        return $this->BldgRoom;
    }
    /**
     * Set BldgRoom value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBldgRoom[] $bldgRoom
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setBldgRoom(array $bldgRoom = array())
    {
        foreach ($bldgRoom as $addressTypeBldgRoomItem) {
            // validation for constraint: itemType
            if (!$addressTypeBldgRoomItem instanceof \dgsoft\StructType\DgBldgRoom) {
                throw new \InvalidArgumentException(sprintf('The BldgRoom property can only contain items of \dgsoft\StructType\DgBldgRoom, "%s" given', is_object($addressTypeBldgRoomItem) ? get_class($addressTypeBldgRoomItem) : gettype($addressTypeBldgRoomItem)), __LINE__);
            }
        }
        $this->BldgRoom = $bldgRoom;
        return $this;
    }
    /**
     * Add item to BldgRoom value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBldgRoom $item
     * @return \dgsoft\StructType\DgAddressType
     */
    public function addToBldgRoom(\dgsoft\StructType\DgBldgRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgBldgRoom) {
            throw new \InvalidArgumentException(sprintf('The BldgRoom property can only contain items of \dgsoft\StructType\DgBldgRoom, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BldgRoom[] = $item;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        foreach ($addressLine as $addressTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressTypeAddressLineItem)) {
                throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of string, "%s" given', is_object($addressTypeAddressLineItem) ? get_class($addressTypeAddressLineItem) : gettype($addressTypeAddressLineItem)), __LINE__);
            }
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgAddressType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get StateProv value
     * @return \dgsoft\StructType\DgStateProvType|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param \dgsoft\StructType\DgStateProvType $stateProv
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setStateProv(\dgsoft\StructType\DgStateProvType $stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get CountryName value
     * @return \dgsoft\StructType\DgCountryNameType|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param \dgsoft\StructType\DgCountryNameType $countryName
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setCountryName(\dgsoft\StructType\DgCountryNameType $countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setFormattedInd($formattedInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($formattedInd) && !is_bool($formattedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($formattedInd)), __LINE__);
        }
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgAddressType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
