<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressHint StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAddressHint extends DgDBBaseEntity
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityID;
    /**
     * The PreferedAddressID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $PreferedAddressID;
    /**
     * The CauseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CauseCode;
    /**
     * Constructor method for AddressHint
     * @uses DgAddressHint::setEntityID()
     * @uses DgAddressHint::setPreferedAddressID()
     * @uses DgAddressHint::setCauseCode()
     * @param string $entityID
     * @param string $preferedAddressID
     * @param string $causeCode
     */
    public function __construct($entityID = null, $preferedAddressID = null, $causeCode = null)
    {
        $this
            ->setEntityID($entityID)
            ->setPreferedAddressID($preferedAddressID)
            ->setCauseCode($causeCode);
    }
    /**
     * Get EntityID value
     * @return string
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \dgsoft\StructType\DgAddressHint
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($entityID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($entityID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get PreferedAddressID value
     * @return string
     */
    public function getPreferedAddressID()
    {
        return $this->PreferedAddressID;
    }
    /**
     * Set PreferedAddressID value
     * @param string $preferedAddressID
     * @return \dgsoft\StructType\DgAddressHint
     */
    public function setPreferedAddressID($preferedAddressID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($preferedAddressID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $preferedAddressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($preferedAddressID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($preferedAddressID) && !is_string($preferedAddressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferedAddressID)), __LINE__);
        }
        $this->PreferedAddressID = $preferedAddressID;
        return $this;
    }
    /**
     * Get CauseCode value
     * @return string|null
     */
    public function getCauseCode()
    {
        return $this->CauseCode;
    }
    /**
     * Set CauseCode value
     * @param string $causeCode
     * @return \dgsoft\StructType\DgAddressHint
     */
    public function setCauseCode($causeCode = null)
    {
        // validation for constraint: string
        if (!is_null($causeCode) && !is_string($causeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($causeCode)), __LINE__);
        }
        $this->CauseCode = $causeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAddressHint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
