<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressDetails StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAddressDetails extends DgBaseEntity
{
    /**
     * The Addresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAddressDB
     */
    public $Addresses;
    /**
     * The AddresHints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAddressHint
     */
    public $AddresHints;
    /**
     * Constructor method for AddressDetails
     * @uses DgAddressDetails::setAddresses()
     * @uses DgAddressDetails::setAddresHints()
     * @param \dgsoft\ArrayType\DgArrayOfAddressDB $addresses
     * @param \dgsoft\ArrayType\DgArrayOfAddressHint $addresHints
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfAddressDB $addresses = null, \dgsoft\ArrayType\DgArrayOfAddressHint $addresHints = null)
    {
        $this
            ->setAddresses($addresses)
            ->setAddresHints($addresHints);
    }
    /**
     * Get Addresses value
     * @return \dgsoft\ArrayType\DgArrayOfAddressDB|null
     */
    public function getAddresses()
    {
        return $this->Addresses;
    }
    /**
     * Set Addresses value
     * @param \dgsoft\ArrayType\DgArrayOfAddressDB $addresses
     * @return \dgsoft\StructType\DgAddressDetails
     */
    public function setAddresses(\dgsoft\ArrayType\DgArrayOfAddressDB $addresses = null)
    {
        $this->Addresses = $addresses;
        return $this;
    }
    /**
     * Get AddresHints value
     * @return \dgsoft\ArrayType\DgArrayOfAddressHint|null
     */
    public function getAddresHints()
    {
        return $this->AddresHints;
    }
    /**
     * Set AddresHints value
     * @param \dgsoft\ArrayType\DgArrayOfAddressHint $addresHints
     * @return \dgsoft\StructType\DgAddressDetails
     */
    public function setAddresHints(\dgsoft\ArrayType\DgArrayOfAddressHint $addresHints = null)
    {
        $this->AddresHints = $addresHints;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAddressDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
