<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressDB StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAddressDB extends DgDBBaseEntity
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityID;
    /**
     * The No
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $No;
    /**
     * The AddressTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressTypeCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityCode;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BankAccountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNo;
    /**
     * The TaxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNumber;
    /**
     * The TaxOffice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOffice;
    /**
     * Constructor method for AddressDB
     * @uses DgAddressDB::setEntityID()
     * @uses DgAddressDB::setNo()
     * @uses DgAddressDB::setAddressTypeCode()
     * @uses DgAddressDB::setCountryCode()
     * @uses DgAddressDB::setCityCode()
     * @uses DgAddressDB::setState()
     * @uses DgAddressDB::setPostalCode()
     * @uses DgAddressDB::setAddressLine1()
     * @uses DgAddressDB::setAddressLine2()
     * @uses DgAddressDB::setContactName()
     * @uses DgAddressDB::setCompanyName()
     * @uses DgAddressDB::setBankName()
     * @uses DgAddressDB::setBankAccountNo()
     * @uses DgAddressDB::setTaxNumber()
     * @uses DgAddressDB::setTaxOffice()
     * @param string $entityID
     * @param int $no
     * @param string $addressTypeCode
     * @param string $countryCode
     * @param string $cityCode
     * @param string $state
     * @param string $postalCode
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $contactName
     * @param string $companyName
     * @param string $bankName
     * @param string $bankAccountNo
     * @param string $taxNumber
     * @param string $taxOffice
     */
    public function __construct($entityID = null, $no = null, $addressTypeCode = null, $countryCode = null, $cityCode = null, $state = null, $postalCode = null, $addressLine1 = null, $addressLine2 = null, $contactName = null, $companyName = null, $bankName = null, $bankAccountNo = null, $taxNumber = null, $taxOffice = null)
    {
        $this
            ->setEntityID($entityID)
            ->setNo($no)
            ->setAddressTypeCode($addressTypeCode)
            ->setCountryCode($countryCode)
            ->setCityCode($cityCode)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setContactName($contactName)
            ->setCompanyName($companyName)
            ->setBankName($bankName)
            ->setBankAccountNo($bankAccountNo)
            ->setTaxNumber($taxNumber)
            ->setTaxOffice($taxOffice);
    }
    /**
     * Get EntityID value
     * @return string
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($entityID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($entityID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get No value
     * @return int
     */
    public function getNo()
    {
        return $this->No;
    }
    /**
     * Set No value
     * @param int $no
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setNo($no = null)
    {
        // validation for constraint: int
        if (!is_null($no) && !is_numeric($no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($no)), __LINE__);
        }
        $this->No = $no;
        return $this;
    }
    /**
     * Get AddressTypeCode value
     * @return string|null
     */
    public function getAddressTypeCode()
    {
        return $this->AddressTypeCode;
    }
    /**
     * Set AddressTypeCode value
     * @param string $addressTypeCode
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setAddressTypeCode($addressTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressTypeCode) && !is_string($addressTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressTypeCode)), __LINE__);
        }
        $this->AddressTypeCode = $addressTypeCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankAccountNo value
     * @return string|null
     */
    public function getBankAccountNo()
    {
        return $this->BankAccountNo;
    }
    /**
     * Set BankAccountNo value
     * @param string $bankAccountNo
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setBankAccountNo($bankAccountNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNo) && !is_string($bankAccountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNo)), __LINE__);
        }
        $this->BankAccountNo = $bankAccountNo;
        return $this;
    }
    /**
     * Get TaxNumber value
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->TaxNumber;
    }
    /**
     * Set TaxNumber value
     * @param string $taxNumber
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxNumber)), __LINE__);
        }
        $this->TaxNumber = $taxNumber;
        return $this;
    }
    /**
     * Get TaxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->TaxOffice;
    }
    /**
     * Set TaxOffice value
     * @param string $taxOffice
     * @return \dgsoft\StructType\DgAddressDB
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxOffice)), __LINE__);
        }
        $this->TaxOffice = $taxOffice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAddressDB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
