<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalDetailType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdditionalDetailType extends AbstractStructBase
{
    /**
     * The DetailDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $DetailDescription;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for AdditionalDetailType
     * @uses DgAdditionalDetailType::setDetailDescription()
     * @uses DgAdditionalDetailType::setType()
     * @uses DgAdditionalDetailType::setCode()
     * @uses DgAdditionalDetailType::setAmount()
     * @param \dgsoft\StructType\DgParagraphType $detailDescription
     * @param string $type
     * @param string $code
     * @param float $amount
     */
    public function __construct(\dgsoft\StructType\DgParagraphType $detailDescription = null, $type = null, $code = null, $amount = null)
    {
        $this
            ->setDetailDescription($detailDescription)
            ->setType($type)
            ->setCode($code)
            ->setAmount($amount);
    }
    /**
     * Get DetailDescription value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getDetailDescription()
    {
        return $this->DetailDescription;
    }
    /**
     * Set DetailDescription value
     * @param \dgsoft\StructType\DgParagraphType $detailDescription
     * @return \dgsoft\StructType\DgAdditionalDetailType
     */
    public function setDetailDescription(\dgsoft\StructType\DgParagraphType $detailDescription = null)
    {
        $this->DetailDescription = $detailDescription;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgAdditionalDetailType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgAdditionalDetailType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgAdditionalDetailType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdditionalDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
