<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharges StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAdditionalCharges extends AbstractStructBase
{
    /**
     * The AdditionalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAdditionalCharge[]
     */
    public $AdditionalCharge;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AdditionalCharges
     * @uses DgAdditionalCharges::setAdditionalCharge()
     * @uses DgAdditionalCharges::setAmountBeforeTax()
     * @uses DgAdditionalCharges::setAmountAfterTax()
     * @uses DgAdditionalCharges::setCurrencyCode()
     * @uses DgAdditionalCharges::setDecimalPlaces()
     * @param \dgsoft\StructType\DgAdditionalCharge[] $additionalCharge
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(array $additionalCharge = array(), $amountBeforeTax = null, $amountAfterTax = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setAdditionalCharge($additionalCharge)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get AdditionalCharge value
     * @return \dgsoft\StructType\DgAdditionalCharge[]|null
     */
    public function getAdditionalCharge()
    {
        return $this->AdditionalCharge;
    }
    /**
     * Set AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAdditionalCharge[] $additionalCharge
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public function setAdditionalCharge(array $additionalCharge = array())
    {
        foreach ($additionalCharge as $additionalChargesAdditionalChargeItem) {
            // validation for constraint: itemType
            if (!$additionalChargesAdditionalChargeItem instanceof \dgsoft\StructType\DgAdditionalCharge) {
                throw new \InvalidArgumentException(sprintf('The AdditionalCharge property can only contain items of \dgsoft\StructType\DgAdditionalCharge, "%s" given', is_object($additionalChargesAdditionalChargeItem) ? get_class($additionalChargesAdditionalChargeItem) : gettype($additionalChargesAdditionalChargeItem)), __LINE__);
            }
        }
        $this->AdditionalCharge = $additionalCharge;
        return $this;
    }
    /**
     * Add item to AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAdditionalCharge $item
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public function addToAdditionalCharge(\dgsoft\StructType\DgAdditionalCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAdditionalCharge) {
            throw new \InvalidArgumentException(sprintf('The AdditionalCharge property can only contain items of \dgsoft\StructType\DgAdditionalCharge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalCharge[] = $item;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAdditionalCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
