<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAccessesType extends AbstractStructBase
{
    /**
     * The Access
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAccess[]
     */
    public $Access;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * Constructor method for AccessesType
     * @uses DgAccessesType::setAccess()
     * @uses DgAccessesType::setShareSynchInd()
     * @uses DgAccessesType::setShareMarketInd()
     * @uses DgAccessesType::setCreateDateTime()
     * @param \dgsoft\StructType\DgAccess[] $access
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $createDateTime
     */
    public function __construct(array $access = array(), $shareSynchInd = null, $shareMarketInd = null, $createDateTime = null)
    {
        $this
            ->setAccess($access)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCreateDateTime($createDateTime);
    }
    /**
     * Get Access value
     * @return \dgsoft\StructType\DgAccess[]|null
     */
    public function getAccess()
    {
        return $this->Access;
    }
    /**
     * Set Access value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAccess[] $access
     * @return \dgsoft\StructType\DgAccessesType
     */
    public function setAccess(array $access = array())
    {
        foreach ($access as $accessesTypeAccessItem) {
            // validation for constraint: itemType
            if (!$accessesTypeAccessItem instanceof \dgsoft\StructType\DgAccess) {
                throw new \InvalidArgumentException(sprintf('The Access property can only contain items of \dgsoft\StructType\DgAccess, "%s" given', is_object($accessesTypeAccessItem) ? get_class($accessesTypeAccessItem) : gettype($accessesTypeAccessItem)), __LINE__);
            }
        }
        $this->Access = $access;
        return $this;
    }
    /**
     * Add item to Access value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAccess $item
     * @return \dgsoft\StructType\DgAccessesType
     */
    public function addToAccess(\dgsoft\StructType\DgAccess $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAccess) {
            throw new \InvalidArgumentException(sprintf('The Access property can only contain items of \dgsoft\StructType\DgAccess, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Access[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgAccessesType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgAccessesType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \dgsoft\StructType\DgAccessesType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAccessesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
