<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptableGuarantee StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAcceptableGuarantee extends \dgsoft\EnumType\DgGuaranteeType
{
    /**
     * The GuaranteePolicyType
     * @var string
     */
    public $GuaranteePolicyType;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The UnacceptablePaymentType
     * @var string
     */
    public $UnacceptablePaymentType;
    /**
     * Constructor method for AcceptableGuarantee
     * @uses DgAcceptableGuarantee::setGuaranteePolicyType()
     * @uses DgAcceptableGuarantee::setPaymentType()
     * @uses DgAcceptableGuarantee::setCurrencyCode()
     * @uses DgAcceptableGuarantee::setDecimalPlaces()
     * @uses DgAcceptableGuarantee::setUnacceptablePaymentType()
     * @param string $guaranteePolicyType
     * @param string $paymentType
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $unacceptablePaymentType
     */
    public function __construct($guaranteePolicyType = null, $paymentType = null, $currencyCode = null, $decimalPlaces = null, $unacceptablePaymentType = null)
    {
        $this
            ->setGuaranteePolicyType($guaranteePolicyType)
            ->setPaymentType($paymentType)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setUnacceptablePaymentType($unacceptablePaymentType);
    }
    /**
     * Get GuaranteePolicyType value
     * @return string|null
     */
    public function getGuaranteePolicyType()
    {
        return $this->GuaranteePolicyType;
    }
    /**
     * Set GuaranteePolicyType value
     * @param string $guaranteePolicyType
     * @return \dgsoft\StructType\DgAcceptableGuarantee
     */
    public function setGuaranteePolicyType($guaranteePolicyType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteePolicyType) && !is_string($guaranteePolicyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guaranteePolicyType)), __LINE__);
        }
        $this->GuaranteePolicyType = $guaranteePolicyType;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \dgsoft\StructType\DgAcceptableGuarantee
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgAcceptableGuarantee
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \dgsoft\StructType\DgAcceptableGuarantee
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get UnacceptablePaymentType value
     * @return string|null
     */
    public function getUnacceptablePaymentType()
    {
        return $this->UnacceptablePaymentType;
    }
    /**
     * Set UnacceptablePaymentType value
     * @param string $unacceptablePaymentType
     * @return \dgsoft\StructType\DgAcceptableGuarantee
     */
    public function setUnacceptablePaymentType($unacceptablePaymentType = null)
    {
        // validation for constraint: string
        if (!is_null($unacceptablePaymentType) && !is_string($unacceptablePaymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unacceptablePaymentType)), __LINE__);
        }
        $this->UnacceptablePaymentType = $unacceptablePaymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAcceptableGuarantee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
