<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APISRuleDocs StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAPISRuleDocs extends AbstractStructBase
{
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The DocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNumber;
    /**
     * The CountryOfIssuance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfIssuance;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nationality;
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The DocumentTypeMandatory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeMandatory;
    /**
     * Constructor method for APISRuleDocs
     * @uses DgAPISRuleDocs::setMiddleName()
     * @uses DgAPISRuleDocs::setDocumentType()
     * @uses DgAPISRuleDocs::setDocumentNumber()
     * @uses DgAPISRuleDocs::setCountryOfIssuance()
     * @uses DgAPISRuleDocs::setNationality()
     * @uses DgAPISRuleDocs::setExpiryDate()
     * @uses DgAPISRuleDocs::setDocumentTypeMandatory()
     * @param string $middleName
     * @param string $documentType
     * @param string $documentNumber
     * @param string $countryOfIssuance
     * @param string $nationality
     * @param string $expiryDate
     * @param string $documentTypeMandatory
     */
    public function __construct($middleName = null, $documentType = null, $documentNumber = null, $countryOfIssuance = null, $nationality = null, $expiryDate = null, $documentTypeMandatory = null)
    {
        $this
            ->setMiddleName($middleName)
            ->setDocumentType($documentType)
            ->setDocumentNumber($documentNumber)
            ->setCountryOfIssuance($countryOfIssuance)
            ->setNationality($nationality)
            ->setExpiryDate($expiryDate)
            ->setDocumentTypeMandatory($documentTypeMandatory);
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get CountryOfIssuance value
     * @return string|null
     */
    public function getCountryOfIssuance()
    {
        return $this->CountryOfIssuance;
    }
    /**
     * Set CountryOfIssuance value
     * @param string $countryOfIssuance
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setCountryOfIssuance($countryOfIssuance = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfIssuance) && !is_string($countryOfIssuance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfIssuance)), __LINE__);
        }
        $this->CountryOfIssuance = $countryOfIssuance;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get DocumentTypeMandatory value
     * @return string|null
     */
    public function getDocumentTypeMandatory()
    {
        return $this->DocumentTypeMandatory;
    }
    /**
     * Set DocumentTypeMandatory value
     * @param string $documentTypeMandatory
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public function setDocumentTypeMandatory($documentTypeMandatory = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeMandatory) && !is_string($documentTypeMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTypeMandatory)), __LINE__);
        }
        $this->DocumentTypeMandatory = $documentTypeMandatory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAPISRuleDocs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
