<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APISRuleDoco StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAPISRuleDoco extends AbstractStructBase
{
    /**
     * The VisaNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VisaNumber;
    /**
     * The PlaceOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfBirth;
    /**
     * The DateOfIssuance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateOfIssuance;
    /**
     * The PlaceOfIssuance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfIssuance;
    /**
     * The CountryRequiringVisa
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryRequiringVisa;
    /**
     * Constructor method for APISRuleDoco
     * @uses DgAPISRuleDoco::setVisaNumber()
     * @uses DgAPISRuleDoco::setPlaceOfBirth()
     * @uses DgAPISRuleDoco::setDateOfIssuance()
     * @uses DgAPISRuleDoco::setPlaceOfIssuance()
     * @uses DgAPISRuleDoco::setCountryRequiringVisa()
     * @param string $visaNumber
     * @param string $placeOfBirth
     * @param string $dateOfIssuance
     * @param string $placeOfIssuance
     * @param string $countryRequiringVisa
     */
    public function __construct($visaNumber = null, $placeOfBirth = null, $dateOfIssuance = null, $placeOfIssuance = null, $countryRequiringVisa = null)
    {
        $this
            ->setVisaNumber($visaNumber)
            ->setPlaceOfBirth($placeOfBirth)
            ->setDateOfIssuance($dateOfIssuance)
            ->setPlaceOfIssuance($placeOfIssuance)
            ->setCountryRequiringVisa($countryRequiringVisa);
    }
    /**
     * Get VisaNumber value
     * @return string|null
     */
    public function getVisaNumber()
    {
        return $this->VisaNumber;
    }
    /**
     * Set VisaNumber value
     * @param string $visaNumber
     * @return \dgsoft\StructType\DgAPISRuleDoco
     */
    public function setVisaNumber($visaNumber = null)
    {
        // validation for constraint: string
        if (!is_null($visaNumber) && !is_string($visaNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($visaNumber)), __LINE__);
        }
        $this->VisaNumber = $visaNumber;
        return $this;
    }
    /**
     * Get PlaceOfBirth value
     * @return string|null
     */
    public function getPlaceOfBirth()
    {
        return $this->PlaceOfBirth;
    }
    /**
     * Set PlaceOfBirth value
     * @param string $placeOfBirth
     * @return \dgsoft\StructType\DgAPISRuleDoco
     */
    public function setPlaceOfBirth($placeOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfBirth) && !is_string($placeOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeOfBirth)), __LINE__);
        }
        $this->PlaceOfBirth = $placeOfBirth;
        return $this;
    }
    /**
     * Get DateOfIssuance value
     * @return string|null
     */
    public function getDateOfIssuance()
    {
        return $this->DateOfIssuance;
    }
    /**
     * Set DateOfIssuance value
     * @param string $dateOfIssuance
     * @return \dgsoft\StructType\DgAPISRuleDoco
     */
    public function setDateOfIssuance($dateOfIssuance = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssuance) && !is_string($dateOfIssuance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfIssuance)), __LINE__);
        }
        $this->DateOfIssuance = $dateOfIssuance;
        return $this;
    }
    /**
     * Get PlaceOfIssuance value
     * @return string|null
     */
    public function getPlaceOfIssuance()
    {
        return $this->PlaceOfIssuance;
    }
    /**
     * Set PlaceOfIssuance value
     * @param string $placeOfIssuance
     * @return \dgsoft\StructType\DgAPISRuleDoco
     */
    public function setPlaceOfIssuance($placeOfIssuance = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfIssuance) && !is_string($placeOfIssuance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeOfIssuance)), __LINE__);
        }
        $this->PlaceOfIssuance = $placeOfIssuance;
        return $this;
    }
    /**
     * Get CountryRequiringVisa value
     * @return string|null
     */
    public function getCountryRequiringVisa()
    {
        return $this->CountryRequiringVisa;
    }
    /**
     * Set CountryRequiringVisa value
     * @param string $countryRequiringVisa
     * @return \dgsoft\StructType\DgAPISRuleDoco
     */
    public function setCountryRequiringVisa($countryRequiringVisa = null)
    {
        // validation for constraint: string
        if (!is_null($countryRequiringVisa) && !is_string($countryRequiringVisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryRequiringVisa)), __LINE__);
        }
        $this->CountryRequiringVisa = $countryRequiringVisa;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAPISRuleDoco
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
