<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APISRuleDoca StructType
 * @package Dg
 * @subpackage Structs
 */
class DgAPISRuleDoca extends AbstractStructBase
{
    /**
     * The AddressType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressType;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The AddressDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDetails;
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityCode;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The ZipPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipPostalCode;
    /**
     * Constructor method for APISRuleDoca
     * @uses DgAPISRuleDoca::setAddressType()
     * @uses DgAPISRuleDoca::setCountryCode()
     * @uses DgAPISRuleDoca::setAddressDetails()
     * @uses DgAPISRuleDoca::setCityCode()
     * @uses DgAPISRuleDoca::setState()
     * @uses DgAPISRuleDoca::setZipPostalCode()
     * @param string $addressType
     * @param string $countryCode
     * @param string $addressDetails
     * @param string $cityCode
     * @param string $state
     * @param string $zipPostalCode
     */
    public function __construct($addressType = null, $countryCode = null, $addressDetails = null, $cityCode = null, $state = null, $zipPostalCode = null)
    {
        $this
            ->setAddressType($addressType)
            ->setCountryCode($countryCode)
            ->setAddressDetails($addressDetails)
            ->setCityCode($cityCode)
            ->setState($state)
            ->setZipPostalCode($zipPostalCode);
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get AddressDetails value
     * @return string|null
     */
    public function getAddressDetails()
    {
        return $this->AddressDetails;
    }
    /**
     * Set AddressDetails value
     * @param string $addressDetails
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public function setAddressDetails($addressDetails = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetails) && !is_string($addressDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressDetails)), __LINE__);
        }
        $this->AddressDetails = $addressDetails;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipPostalCode value
     * @return string|null
     */
    public function getZipPostalCode()
    {
        return $this->ZipPostalCode;
    }
    /**
     * Set ZipPostalCode value
     * @param string $zipPostalCode
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public function setZipPostalCode($zipPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipPostalCode) && !is_string($zipPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipPostalCode)), __LINE__);
        }
        $this->ZipPostalCode = $zipPostalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgAPISRuleDoca
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
