<?php

namespace dgsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sign ServiceType
 * @package Dg
 * @subpackage Services
 */
class DgSign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SignOut
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgSignOut $parameters
     * @return \dgsoft\StructType\DgSignOutResponse|bool
     */
    public function SignOut(\dgsoft\StructType\DgSignOut $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SignOut($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dgsoft\StructType\DgSignOutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
