<?php

namespace dgsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Queue ServiceType
 * @package Dg
 * @subpackage Services
 */
class DgQueue extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationSoapHeader(\dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationSoapHeader', $authenticationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the GenericSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGenericSoapHeader(\dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'GenericSoapHeader', $genericSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Queue
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgQueue $parameters
     * @return \dgsoft\StructType\DgQueueResponse|bool
     */
    public function Queue(\dgsoft\StructType\DgQueue $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Queue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dgsoft\StructType\DgQueueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
