<?php

namespace dgsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package Dg
 * @subpackage Services
 */
class DgGet extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationSoapHeader(\dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationSoapHeader', $authenticationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the GenericSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGenericSoapHeader(\dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'GenericSoapHeader', $genericSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetServiceFee
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetServiceFee $parameters
     * @return \dgsoft\StructType\DgGetServiceFeeResponse|bool
     */
    public function GetServiceFee(\dgsoft\StructType\DgGetServiceFee $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServiceFee($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBaggageInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetBaggageInfo $parameters
     * @return \dgsoft\StructType\DgGetBaggageInfoResponse|bool
     */
    public function GetBaggageInfo(\dgsoft\StructType\DgGetBaggageInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBaggageInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAncillaryInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetAncillaryInfo $parameters
     * @return \dgsoft\StructType\DgGetAncillaryInfoResponse|bool
     */
    public function GetAncillaryInfo(\dgsoft\StructType\DgGetAncillaryInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAncillaryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCompatibleLowestFaresForSunExpress
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetCompatibleLowestFaresForSunExpress $parameters
     * @return \dgsoft\StructType\DgGetCompatibleLowestFaresForSunExpressResponse|bool
     */
    public function GetCompatibleLowestFaresForSunExpress(\dgsoft\StructType\DgGetCompatibleLowestFaresForSunExpress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompatibleLowestFaresForSunExpress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceFeeV2
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetServiceFeeV2 $parameters
     * @return \dgsoft\StructType\DgGetServiceFeeV2Response|bool
     */
    public function GetServiceFeeV2(\dgsoft\StructType\DgGetServiceFeeV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServiceFeeV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPrice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetPrice $parameters
     * @return \dgsoft\StructType\DgGetPriceResponse|bool
     */
    public function GetPrice(\dgsoft\StructType\DgGetPrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRequiredParametersForLCC
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetRequiredParametersForLCC $parameters
     * @return \dgsoft\StructType\DgGetRequiredParametersForLCCResponse|bool
     */
    public function GetRequiredParametersForLCC(\dgsoft\StructType\DgGetRequiredParametersForLCC $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRequiredParametersForLCC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNextFlightResults
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetNextFlightResults $parameters
     * @return \dgsoft\StructType\DgGetNextFlightResultsResponse|bool
     */
    public function GetNextFlightResults(\dgsoft\StructType\DgGetNextFlightResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNextFlightResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFlightRules
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetFlightRules $parameters
     * @return \dgsoft\StructType\DgGetFlightRulesResponse|bool
     */
    public function GetFlightRules(\dgsoft\StructType\DgGetFlightRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFlightRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPNR
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetPNR $parameters
     * @return \dgsoft\StructType\DgGetPNRResponse|bool
     */
    public function GetPNR(\dgsoft\StructType\DgGetPNR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPNRPrice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetPNRPrice $parameters
     * @return \dgsoft\StructType\DgGetPNRPriceResponse|bool
     */
    public function GetPNRPrice(\dgsoft\StructType\DgGetPNRPrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPNRPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastTicketingDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetLastTicketingDate $parameters
     * @return \dgsoft\StructType\DgGetLastTicketingDateResponse|bool
     */
    public function GetLastTicketingDate(\dgsoft\StructType\DgGetLastTicketingDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLastTicketingDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSeatMap
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetSeatMap $parameters
     * @return \dgsoft\StructType\DgGetSeatMapResponse|bool
     */
    public function GetSeatMap(\dgsoft\StructType\DgGetSeatMap $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSeatMap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCancelPolicyText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetCancelPolicyText $parameters
     * @return \dgsoft\StructType\DgGetCancelPolicyTextResponse|bool
     */
    public function GetCancelPolicyText(\dgsoft\StructType\DgGetCancelPolicyText $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCancelPolicyText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHotelInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetHotelInfo $parameters
     * @return \dgsoft\StructType\DgGetHotelInfoResponse|bool
     */
    public function GetHotelInfo(\dgsoft\StructType\DgGetHotelInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHotelInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHotelRoomRules
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetHotelRoomRules $parameters
     * @return \dgsoft\StructType\DgGetHotelRoomRulesResponse|bool
     */
    public function GetHotelRoomRules(\dgsoft\StructType\DgGetHotelRoomRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHotelRoomRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHotelPNR
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetHotelPNR $parameters
     * @return \dgsoft\StructType\DgGetHotelPNRResponse|bool
     */
    public function GetHotelPNR(\dgsoft\StructType\DgGetHotelPNR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHotelPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCarCompanyLocations
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetCarCompanyLocations $parameters
     * @return \dgsoft\StructType\DgGetCarCompanyLocationsResponse|bool
     */
    public function GetCarCompanyLocations(\dgsoft\StructType\DgGetCarCompanyLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCarCompanyLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCarRules
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetCarRules $parameters
     * @return \dgsoft\StructType\DgGetCarRulesResponse|bool
     */
    public function GetCarRules(\dgsoft\StructType\DgGetCarRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCarRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCarPNR
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetCarPNR $parameters
     * @return \dgsoft\StructType\DgGetCarPNRResponse|bool
     */
    public function GetCarPNR(\dgsoft\StructType\DgGetCarPNR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCarPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBasketPNR
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetBasketPNR $parameters
     * @return \dgsoft\StructType\DgGetBasketPNRResponse|bool
     */
    public function GetBasketPNR(\dgsoft\StructType\DgGetBasketPNR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBasketPNR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetUser $parameters
     * @return \dgsoft\StructType\DgGetUserResponse|bool
     */
    public function GetUser(\dgsoft\StructType\DgGetUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAPISRules
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetAPISRules $parameters
     * @return \dgsoft\StructType\DgGetAPISRulesResponse|bool
     */
    public function GetAPISRules(\dgsoft\StructType\DgGetAPISRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAPISRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFlightFareFamilies
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgGetFlightFareFamilies $parameters
     * @return \dgsoft\StructType\DgGetFlightFareFamiliesResponse|bool
     */
    public function GetFlightFareFamilies(\dgsoft\StructType\DgGetFlightFareFamilies $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFlightFareFamilies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dgsoft\StructType\DgGetAncillaryInfoResponse|\dgsoft\StructType\DgGetAPISRulesResponse|\dgsoft\StructType\DgGetBaggageInfoResponse|\dgsoft\StructType\DgGetBasketPNRResponse|\dgsoft\StructType\DgGetCancelPolicyTextResponse|\dgsoft\StructType\DgGetCarCompanyLocationsResponse|\dgsoft\StructType\DgGetCarPNRResponse|\dgsoft\StructType\DgGetCarRulesResponse|\dgsoft\StructType\DgGetCompatibleLowestFaresForSunExpressResponse|\dgsoft\StructType\DgGetFlightFareFamiliesResponse|\dgsoft\StructType\DgGetFlightRulesResponse|\dgsoft\StructType\DgGetHotelInfoResponse|\dgsoft\StructType\DgGetHotelPNRResponse|\dgsoft\StructType\DgGetHotelRoomRulesResponse|\dgsoft\StructType\DgGetLastTicketingDateResponse|\dgsoft\StructType\DgGetNextFlightResultsResponse|\dgsoft\StructType\DgGetPNRPriceResponse|\dgsoft\StructType\DgGetPNRResponse|\dgsoft\StructType\DgGetPriceResponse|\dgsoft\StructType\DgGetRequiredParametersForLCCResponse|\dgsoft\StructType\DgGetSeatMapResponse|\dgsoft\StructType\DgGetServiceFeeResponse|\dgsoft\StructType\DgGetServiceFeeV2Response|\dgsoft\StructType\DgGetUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
