<?php

namespace dgsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Book ServiceType
 * @package Dg
 * @subpackage Services
 */
class DgBook extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationSoapHeader(\dgsoft\StructType\DgAuthenticationSoapHeader $authenticationSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationSoapHeader', $authenticationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the GenericSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGenericSoapHeader(\dgsoft\StructType\DgGenericSoapHeader $genericSoapHeader, $nameSpace = 'http://epowerv5.amadeus.com.tr/WS', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'GenericSoapHeader', $genericSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named BookFlight
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgBookFlight $parameters
     * @return \dgsoft\StructType\DgBookFlightResponse|bool
     */
    public function BookFlight(\dgsoft\StructType\DgBookFlight $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BookFlight($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookFlightWithRecommendation
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgBookFlightWithRecommendation $parameters
     * @return \dgsoft\StructType\DgBookFlightWithRecommendationResponse|bool
     */
    public function BookFlightWithRecommendation(\dgsoft\StructType\DgBookFlightWithRecommendation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BookFlightWithRecommendation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookHotel
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgBookHotel $parameters
     * @return \dgsoft\StructType\DgBookHotelResponse|bool
     */
    public function BookHotel(\dgsoft\StructType\DgBookHotel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BookHotel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookCar
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgBookCar $parameters
     * @return \dgsoft\StructType\DgBookCarResponse|bool
     */
    public function BookCar(\dgsoft\StructType\DgBookCar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BookCar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookInsurance
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgBookInsurance $parameters
     * @return \dgsoft\StructType\DgBookInsuranceResponse|bool
     */
    public function BookInsurance(\dgsoft\StructType\DgBookInsurance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BookInsurance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Book
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationSoapHeader, GenericSoapHeader
     * - SOAPHeaderNamespaces: http://epowerv5.amadeus.com.tr/WS, http://epowerv5.amadeus.com.tr/WS
     * - SOAPHeaderTypes: \dgsoft\StructType\DgAuthenticationSoapHeader, \dgsoft\StructType\DgGenericSoapHeader
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \dgsoft\StructType\DgBook $parameters
     * @return \dgsoft\StructType\DgBookResponse|bool
     */
    public function Book(\dgsoft\StructType\DgBook $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Book($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \dgsoft\StructType\DgBookCarResponse|\dgsoft\StructType\DgBookFlightResponse|\dgsoft\StructType\DgBookFlightWithRecommendationResponse|\dgsoft\StructType\DgBookHotelResponse|\dgsoft\StructType\DgBookInsuranceResponse|\dgsoft\StructType\DgBookResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
