<?php

namespace dgsoft\EnumType;

/**
 * This class stands for VehicleRentalRateTypeRateRestrictionsOneWayPolicy EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgVehicleRentalRateTypeRateRestrictionsOneWayPolicy
{
    /**
     * Constant for value 'OneWayAllowed'
     * @return string 'OneWayAllowed'
     */
    const VALUE_ONE_WAY_ALLOWED = 'OneWayAllowed';
    /**
     * Constant for value 'OneWayNotAllowed'
     * @return string 'OneWayNotAllowed'
     */
    const VALUE_ONE_WAY_NOT_ALLOWED = 'OneWayNotAllowed';
    /**
     * Constant for value 'RestrictedOneWay'
     * @return string 'RestrictedOneWay'
     */
    const VALUE_RESTRICTED_ONE_WAY = 'RestrictedOneWay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONE_WAY_ALLOWED
     * @uses self::VALUE_ONE_WAY_NOT_ALLOWED
     * @uses self::VALUE_RESTRICTED_ONE_WAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONE_WAY_ALLOWED,
            self::VALUE_ONE_WAY_NOT_ALLOWED,
            self::VALUE_RESTRICTED_ONE_WAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
