<?php

namespace dgsoft\EnumType;

/**
 * This class stands for VehicleRentalRateTypeRateGuaranteeOffsetDropTime EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime
{
    /**
     * Constant for value 'BeforeArrival'
     * @return string 'BeforeArrival'
     */
    const VALUE_BEFORE_ARRIVAL = 'BeforeArrival';
    /**
     * Constant for value 'AfterBooking'
     * @return string 'AfterBooking'
     */
    const VALUE_AFTER_BOOKING = 'AfterBooking';
    /**
     * Constant for value 'AfterConfirmation'
     * @return string 'AfterConfirmation'
     */
    const VALUE_AFTER_CONFIRMATION = 'AfterConfirmation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEFORE_ARRIVAL
     * @uses self::VALUE_AFTER_BOOKING
     * @uses self::VALUE_AFTER_CONFIRMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEFORE_ARRIVAL,
            self::VALUE_AFTER_BOOKING,
            self::VALUE_AFTER_CONFIRMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
