<?php

namespace dgsoft\EnumType;

/**
 * This class stands for ValidationErrorTypes EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgValidationErrorTypes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'ValidationError'
     * @return string 'ValidationError'
     */
    const VALUE_VALIDATION_ERROR = 'ValidationError';
    /**
     * Constant for value 'AmadeusAPIError'
     * @return string 'AmadeusAPIError'
     */
    const VALUE_AMADEUS_APIERROR = 'AmadeusAPIError';
    /**
     * Constant for value 'EpowerInternalError'
     * @return string 'EpowerInternalError'
     */
    const VALUE_EPOWER_INTERNAL_ERROR = 'EpowerInternalError';
    /**
     * Constant for value 'EpowerUnhandledError'
     * @return string 'EpowerUnhandledError'
     */
    const VALUE_EPOWER_UNHANDLED_ERROR = 'EpowerUnhandledError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_VALIDATION_ERROR
     * @uses self::VALUE_AMADEUS_APIERROR
     * @uses self::VALUE_EPOWER_INTERNAL_ERROR
     * @uses self::VALUE_EPOWER_UNHANDLED_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_VALIDATION_ERROR,
            self::VALUE_AMADEUS_APIERROR,
            self::VALUE_EPOWER_INTERNAL_ERROR,
            self::VALUE_EPOWER_UNHANDLED_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
