<?php

namespace dgsoft\EnumType;

/**
 * This class stands for UICustomizationsRights EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgUICustomizationsRights
{
    /**
     * Constant for value 'IsHostAdmin'
     * @return string 'IsHostAdmin'
     */
    const VALUE_IS_HOST_ADMIN = 'IsHostAdmin';
    /**
     * Constant for value 'IsThemeRoller'
     * @return string 'IsThemeRoller'
     */
    const VALUE_IS_THEME_ROLLER = 'IsThemeRoller';
    /**
     * Constant for value 'IsThemeWizard'
     * @return string 'IsThemeWizard'
     */
    const VALUE_IS_THEME_WIZARD = 'IsThemeWizard';
    /**
     * Constant for value 'IsFileMang'
     * @return string 'IsFileMang'
     */
    const VALUE_IS_FILE_MANG = 'IsFileMang';
    /**
     * Constant for value 'IsFMMasterFiles'
     * @return string 'IsFMMasterFiles'
     */
    const VALUE_IS_FMMASTER_FILES = 'IsFMMasterFiles';
    /**
     * Constant for value 'IsAccessHostAdminMenu'
     * @return string 'IsAccessHostAdminMenu'
     */
    const VALUE_IS_ACCESS_HOST_ADMIN_MENU = 'IsAccessHostAdminMenu';
    /**
     * Constant for value 'IsAgencyRules'
     * @return string 'IsAgencyRules'
     */
    const VALUE_IS_AGENCY_RULES = 'IsAgencyRules';
    /**
     * Constant for value 'IsUserFromAdmin'
     * @return string 'IsUserFromAdmin'
     */
    const VALUE_IS_USER_FROM_ADMIN = 'IsUserFromAdmin';
    /**
     * Constant for value 'IsHeaderFooterAdmin'
     * @return string 'IsHeaderFooterAdmin'
     */
    const VALUE_IS_HEADER_FOOTER_ADMIN = 'IsHeaderFooterAdmin';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IS_HOST_ADMIN
     * @uses self::VALUE_IS_THEME_ROLLER
     * @uses self::VALUE_IS_THEME_WIZARD
     * @uses self::VALUE_IS_FILE_MANG
     * @uses self::VALUE_IS_FMMASTER_FILES
     * @uses self::VALUE_IS_ACCESS_HOST_ADMIN_MENU
     * @uses self::VALUE_IS_AGENCY_RULES
     * @uses self::VALUE_IS_USER_FROM_ADMIN
     * @uses self::VALUE_IS_HEADER_FOOTER_ADMIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IS_HOST_ADMIN,
            self::VALUE_IS_THEME_ROLLER,
            self::VALUE_IS_THEME_WIZARD,
            self::VALUE_IS_FILE_MANG,
            self::VALUE_IS_FMMASTER_FILES,
            self::VALUE_IS_ACCESS_HOST_ADMIN_MENU,
            self::VALUE_IS_AGENCY_RULES,
            self::VALUE_IS_USER_FROM_ADMIN,
            self::VALUE_IS_HEADER_FOOTER_ADMIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
