<?php

namespace dgsoft\EnumType;

/**
 * This class stands for TripApprovalRuleEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgTripApprovalRuleEnum
{
    /**
     * Constant for value 'NEVERNEEDSAPPROVAL'
     * @return string 'NEVERNEEDSAPPROVAL'
     */
    const VALUE_NEVERNEEDSAPPROVAL = 'NEVERNEEDSAPPROVAL';
    /**
     * Constant for value 'ALWAYSNEEDSAPPROVAL'
     * @return string 'ALWAYSNEEDSAPPROVAL'
     */
    const VALUE_ALWAYSNEEDSAPPROVAL = 'ALWAYSNEEDSAPPROVAL';
    /**
     * Constant for value 'NEEDSAPPROVALWHENTRIPISOUTOFPOLICY'
     * @return string 'NEEDSAPPROVALWHENTRIPISOUTOFPOLICY'
     */
    const VALUE_NEEDSAPPROVALWHENTRIPISOUTOFPOLICY = 'NEEDSAPPROVALWHENTRIPISOUTOFPOLICY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEVERNEEDSAPPROVAL
     * @uses self::VALUE_ALWAYSNEEDSAPPROVAL
     * @uses self::VALUE_NEEDSAPPROVALWHENTRIPISOUTOFPOLICY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEVERNEEDSAPPROVAL,
            self::VALUE_ALWAYSNEEDSAPPROVAL,
            self::VALUE_NEEDSAPPROVALWHENTRIPISOUTOFPOLICY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
