<?php

namespace dgsoft\EnumType;

/**
 * This class stands for TicketType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgTicketType
{
    /**
     * Constant for value 'BookingOnly'
     * @return string 'BookingOnly'
     */
    const VALUE_BOOKING_ONLY = 'BookingOnly';
    /**
     * Constant for value 'ETicketInstant'
     * @return string 'ETicketInstant'
     */
    const VALUE_ETICKET_INSTANT = 'ETicketInstant';
    /**
     * Constant for value 'ETicketRequest'
     * @return string 'ETicketRequest'
     */
    const VALUE_ETICKET_REQUEST = 'ETicketRequest';
    /**
     * Constant for value 'MyAddress'
     * @return string 'MyAddress'
     */
    const VALUE_MY_ADDRESS = 'MyAddress';
    /**
     * Constant for value 'Ticketless'
     * @return string 'Ticketless'
     */
    const VALUE_TICKETLESS = 'Ticketless';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOOKING_ONLY
     * @uses self::VALUE_ETICKET_INSTANT
     * @uses self::VALUE_ETICKET_REQUEST
     * @uses self::VALUE_MY_ADDRESS
     * @uses self::VALUE_TICKETLESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOOKING_ONLY,
            self::VALUE_ETICKET_INSTANT,
            self::VALUE_ETICKET_REQUEST,
            self::VALUE_MY_ADDRESS,
            self::VALUE_TICKETLESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
