<?php

namespace dgsoft\EnumType;

/**
 * This class stands for RefundableTypesEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgRefundableTypesEnum
{
    /**
     * Constant for value 'AllFlights'
     * @return string 'AllFlights'
     */
    const VALUE_ALL_FLIGHTS = 'AllFlights';
    /**
     * Constant for value 'OnlyRefundable'
     * @return string 'OnlyRefundable'
     */
    const VALUE_ONLY_REFUNDABLE = 'OnlyRefundable';
    /**
     * Constant for value 'OnlyNonRefundable'
     * @return string 'OnlyNonRefundable'
     */
    const VALUE_ONLY_NON_REFUNDABLE = 'OnlyNonRefundable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_FLIGHTS
     * @uses self::VALUE_ONLY_REFUNDABLE
     * @uses self::VALUE_ONLY_NON_REFUNDABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_FLIGHTS,
            self::VALUE_ONLY_REFUNDABLE,
            self::VALUE_ONLY_NON_REFUNDABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
