<?php

namespace dgsoft\EnumType;

/**
 * This class stands for RailProviderTypeEnum EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgRailProviderTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'SNCFProvider'
     * @return string 'SNCFProvider'
     */
    const VALUE_SNCFPROVIDER = 'SNCFProvider';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SNCFPROVIDER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SNCFPROVIDER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
