<?php

namespace dgsoft\EnumType;

/**
 * This class stands for OTA_AirSeatMapRSSeatMapResponsesAirTravelerGender EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgOTA_AirSeatMapRSSeatMapResponsesAirTravelerGender
{
    /**
     * Constant for value 'Male'
     * @return string 'Male'
     */
    const VALUE_MALE = 'Male';
    /**
     * Constant for value 'Female'
     * @return string 'Female'
     */
    const VALUE_FEMALE = 'Female';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MALE
     * @uses self::VALUE_FEMALE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MALE,
            self::VALUE_FEMALE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
