<?php

namespace dgsoft\EnumType;

/**
 * This class stands for OTA_AirScheduleRQFlightTypePrefRoutingType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgOTA_AirScheduleRQFlightTypePrefRoutingType
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Mirror'
     * @return string 'Mirror'
     */
    const VALUE_MIRROR = 'Mirror';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_MIRROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_MIRROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
