<?php

namespace dgsoft\EnumType;

/**
 * This class stands for FailbackExceptionErrorType EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgFailbackExceptionErrorType
{
    /**
     * Constant for value 'SeatTaken'
     * @return string 'SeatTaken'
     */
    const VALUE_SEAT_TAKEN = 'SeatTaken';
    /**
     * Constant for value 'ScheduleChange'
     * @return string 'ScheduleChange'
     */
    const VALUE_SCHEDULE_CHANGE = 'ScheduleChange';
    /**
     * Constant for value 'PriceChange'
     * @return string 'PriceChange'
     */
    const VALUE_PRICE_CHANGE = 'PriceChange';
    /**
     * Constant for value 'FareBasisChange'
     * @return string 'FareBasisChange'
     */
    const VALUE_FARE_BASIS_CHANGE = 'FareBasisChange';
    /**
     * Constant for value 'PricingFareEror'
     * @return string 'PricingFareEror'
     */
    const VALUE_PRICING_FARE_EROR = 'PricingFareEror';
    /**
     * Constant for value 'AncillaryPriceChange'
     * @return string 'AncillaryPriceChange'
     */
    const VALUE_ANCILLARY_PRICE_CHANGE = 'AncillaryPriceChange';
    /**
     * Constant for value 'FailbackDone'
     * @return string 'FailbackDone'
     */
    const VALUE_FAILBACK_DONE = 'FailbackDone';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEAT_TAKEN
     * @uses self::VALUE_SCHEDULE_CHANGE
     * @uses self::VALUE_PRICE_CHANGE
     * @uses self::VALUE_FARE_BASIS_CHANGE
     * @uses self::VALUE_PRICING_FARE_EROR
     * @uses self::VALUE_ANCILLARY_PRICE_CHANGE
     * @uses self::VALUE_FAILBACK_DONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEAT_TAKEN,
            self::VALUE_SCHEDULE_CHANGE,
            self::VALUE_PRICE_CHANGE,
            self::VALUE_FARE_BASIS_CHANGE,
            self::VALUE_PRICING_FARE_EROR,
            self::VALUE_ANCILLARY_PRICE_CHANGE,
            self::VALUE_FAILBACK_DONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
