<?php

namespace dgsoft\EnumType;

/**
 * This class stands for CustomerPrimaryAdditionalTypeAdditionalQualificationMethod
 * EnumType
 * @package Dg
 * @subpackage Enumerations
 */
class DgCustomerPrimaryAdditionalTypeAdditionalQualificationMethod
{
    /**
     * Constant for value 'RT_AirlineTicket'
     * @return string 'RT_AirlineTicket'
     */
    const VALUE_RT_AIRLINE_TICKET = 'RT_AirlineTicket';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'PassportAndReturnTkt'
     * @return string 'PassportAndReturnTkt'
     */
    const VALUE_PASSPORT_AND_RETURN_TKT = 'PassportAndReturnTkt';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RT_AIRLINE_TICKET
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_PASSPORT_AND_RETURN_TKT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RT_AIRLINE_TICKET,
            self::VALUE_CREDIT_CARD,
            self::VALUE_PASSPORT_AND_RETURN_TKT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
